/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import com.google.common.collect.Iterables;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeItem;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.CopyHandlerHelper;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class RequirementItem
extends ComponentRequirement<ItemStack, RequirementTypeItem>
implements ComponentRequirement.ChancedRequirement {
    public final ItemRequirementType requirementType;
    public final ItemStack required;
    public final String oreDictName;
    public final int oreDictItemAmount;
    public final int fuelBurntime;
    public int countIOBuffer = 0;
    public NBTTagCompound tag = null;
    public NBTTagCompound previewDisplayTag = null;
    public float chance = 1.0f;

    public RequirementItem(IOType ioType, ItemStack item) {
        super(RequirementTypesMM.REQUIREMENT_ITEM, ioType);
        this.requirementType = ItemRequirementType.ITEMSTACKS;
        this.required = item.func_77946_l();
        this.oreDictName = null;
        this.oreDictItemAmount = 0;
        this.fuelBurntime = 0;
    }

    public RequirementItem(IOType ioType, String oreDictName, int oreDictAmount) {
        super(RequirementTypesMM.REQUIREMENT_ITEM, ioType);
        this.requirementType = ItemRequirementType.OREDICT;
        this.oreDictName = oreDictName;
        this.oreDictItemAmount = oreDictAmount;
        this.required = ItemStack.field_190927_a;
        this.fuelBurntime = 0;
    }

    public RequirementItem(IOType actionType, int fuelBurntime) {
        super(RequirementTypesMM.REQUIREMENT_ITEM, actionType);
        this.requirementType = ItemRequirementType.FUEL;
        this.fuelBurntime = fuelBurntime;
        this.oreDictName = null;
        this.oreDictItemAmount = 0;
        this.required = ItemStack.field_190927_a;
    }

    @Override
    public int getSortingWeight() {
        return 50000;
    }

    @Override
    public ComponentRequirement<ItemStack, RequirementTypeItem> deepCopy() {
        RequirementItem item;
        switch (this.requirementType) {
            case OREDICT: {
                item = new RequirementItem(this.getActionType(), this.oreDictName, this.oreDictItemAmount);
                break;
            }
            case FUEL: {
                item = new RequirementItem(this.getActionType(), this.fuelBurntime);
                break;
            }
            default: {
                item = new RequirementItem(this.getActionType(), this.required.func_77946_l());
            }
        }
        item.chance = this.chance;
        if (this.tag != null) {
            item.tag = this.tag.func_74737_b();
        }
        if (this.previewDisplayTag != null) {
            item.previewDisplayTag = this.previewDisplayTag.func_74737_b();
        }
        return item;
    }

    @Override
    public ComponentRequirement<ItemStack, RequirementTypeItem> deepCopyModified(List<RecipeModifier> modifiers) {
        RequirementItem item;
        switch (this.requirementType) {
            case OREDICT: {
                int inOreAmt = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)this.oreDictItemAmount, false));
                item = new RequirementItem(this.getActionType(), this.oreDictName, inOreAmt);
                break;
            }
            case FUEL: {
                int inFuel = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)this.fuelBurntime, false));
                item = new RequirementItem(this.getActionType(), inFuel);
                break;
            }
            default: {
                ItemStack inReq = this.required.func_77946_l();
                int amt = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)inReq.func_190916_E(), false));
                inReq.func_190920_e(amt);
                item = new RequirementItem(this.getActionType(), inReq);
            }
        }
        item.chance = RecipeModifier.applyModifiers(modifiers, this, this.chance, true);
        if (this.tag != null) {
            item.tag = this.tag.func_74737_b();
        }
        if (this.previewDisplayTag != null) {
            item.previewDisplayTag = this.previewDisplayTag.func_74737_b();
        }
        return item;
    }

    @Override
    public ComponentRequirement.JEIComponent<ItemStack> provideJEIComponent() {
        return new JEIComponentItem(this);
    }

    @Override
    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
        switch (this.requirementType) {
            case ITEMSTACKS: {
                this.countIOBuffer = this.required.func_190916_E();
                break;
            }
            case OREDICT: {
                this.countIOBuffer = this.oreDictItemAmount;
                break;
            }
            case FUEL: {
                this.countIOBuffer = this.fuelBurntime;
            }
        }
        this.countIOBuffer = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.countIOBuffer, false));
    }

    @Override
    public void endRequirementCheck() {
        this.countIOBuffer = 0;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeItem)((Object)this.getRequirementType())).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType().equals((Object)ComponentTypesMM.COMPONENT_ITEM) && cmp instanceof MachineComponent.ItemBus && cmp.getIOType() == this.getActionType();
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        IOInventory handler = (IOInventory)component.getProvidedComponent();
        switch (this.getActionType()) {
            case INPUT: {
                switch (this.requirementType) {
                    case ITEMSTACKS: {
                        ItemStack inReq = this.required.func_77946_l();
                        int n = Math.round(RecipeModifier.applyModifiers(context, this, (float)inReq.func_190916_E(), false));
                        inReq.func_190920_e(n);
                        if (!ItemUtils.consumeFromInventory(handler, inReq, true, this.tag)) break;
                        return CraftCheck.success();
                    }
                    case OREDICT: {
                        int inOreAmt = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.oreDictItemAmount, false));
                        if (!ItemUtils.consumeFromInventoryOreDict(handler, this.oreDictName, inOreAmt, true, this.tag)) break;
                        return CraftCheck.success();
                    }
                    case FUEL: {
                        int inFuel = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.fuelBurntime, false));
                        if (ItemUtils.consumeFromInventoryFuel(handler, inFuel, true, this.tag) > 0) break;
                        return CraftCheck.success();
                    }
                }
                return CraftCheck.failure("craftcheck.failure.item.input");
            }
            case OUTPUT: {
                int n;
                handler = CopyHandlerHelper.copyInventory(handler);
                for (ComponentOutputRestrictor componentOutputRestrictor : restrictions) {
                    if (!(componentOutputRestrictor instanceof ComponentOutputRestrictor.RestrictionInventory)) continue;
                    ComponentOutputRestrictor.RestrictionInventory inv = (ComponentOutputRestrictor.RestrictionInventory)componentOutputRestrictor;
                    if (!inv.exactComponent.equals(component)) continue;
                    ItemUtils.tryPlaceItemInInventory(inv.inserted.func_77946_l(), handler, false);
                }
                ItemStack stack = ItemStack.field_190927_a;
                if (this.oreDictName != null) {
                    ItemStack oreInstance;
                    Iterator iterator = OreDictionary.getOres((String)this.oreDictName).iterator();
                    while (iterator.hasNext() && ((oreInstance = (ItemStack)iterator.next()).func_190926_b() || (stack = ItemUtils.copyStackWithSize(oreInstance, this.countIOBuffer)).func_190926_b())) {
                    }
                    if (this.countIOBuffer > 0 && stack.func_190926_b()) {
                        throw new IllegalArgumentException("Unknown ItemStack: Cannot find an item in oredict '" + this.oreDictName + "'!");
                    }
                } else {
                    stack = ItemUtils.copyStackWithSize(this.required, this.countIOBuffer);
                }
                if (this.tag != null) {
                    stack.func_77982_d(this.tag.func_74737_b());
                }
                if ((n = ItemUtils.tryPlaceItemInInventory(stack.func_77946_l(), handler, true)) > 0) {
                    context.addRestriction(new ComponentOutputRestrictor.RestrictionInventory(ItemUtils.copyStackWithSize(stack, n), component));
                }
                this.countIOBuffer -= n;
                if (this.countIOBuffer <= 0) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure("craftcheck.failure.item.output.space");
            }
        }
        return CraftCheck.skipComponent();
    }

    @Override
    public boolean startCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        IOInventory handler = (IOInventory)component.getProvidedComponent();
        float productionChance = RecipeModifier.applyModifiers(context, this, this.chance, true);
        switch (this.getActionType()) {
            case INPUT: {
                switch (this.requirementType) {
                    case ITEMSTACKS: {
                        ItemStack stackRequired = this.required.func_77946_l();
                        int amt = Math.round(RecipeModifier.applyModifiers(context, this, (float)stackRequired.func_190916_E(), false));
                        stackRequired.func_190920_e(amt);
                        boolean can = ItemUtils.consumeFromInventory(handler, stackRequired, true, this.tag);
                        if (chance.canProduce(productionChance)) {
                            return can;
                        }
                        return can && ItemUtils.consumeFromInventory(handler, stackRequired, false, this.tag);
                    }
                    case OREDICT: {
                        int requiredOredict = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.oreDictItemAmount, false));
                        boolean can = ItemUtils.consumeFromInventoryOreDict(handler, this.oreDictName, requiredOredict, true, this.tag);
                        if (chance.canProduce(productionChance)) {
                            return can;
                        }
                        return can && ItemUtils.consumeFromInventoryOreDict(handler, this.oreDictName, requiredOredict, false, this.tag);
                    }
                    case FUEL: {
                        boolean can;
                        int requiredBurnTime = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.fuelBurntime, false));
                        boolean bl = can = ItemUtils.consumeFromInventoryFuel(handler, requiredBurnTime, true, this.tag) <= 0;
                        if (chance.canProduce(productionChance)) {
                            return can;
                        }
                        return can && ItemUtils.consumeFromInventoryFuel(handler, requiredBurnTime, false, this.tag) <= 0;
                    }
                }
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public CraftCheck finishCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        if (this.fuelBurntime > 0 && this.oreDictName == null && this.required.func_190926_b()) {
            throw new IllegalStateException("Invalid item output!");
        }
        IOInventory handler = (IOInventory)component.getProvidedComponent();
        switch (this.getActionType()) {
            case OUTPUT: {
                int inserted;
                ItemStack stack;
                if (this.oreDictName != null) {
                    stack = (ItemStack)Iterables.getFirst((Iterable)OreDictionary.getOres((String)this.oreDictName), (Object)ItemStack.field_190927_a);
                    stack = ItemUtils.copyStackWithSize(stack, this.countIOBuffer);
                } else {
                    stack = ItemUtils.copyStackWithSize(this.required, this.countIOBuffer);
                }
                if (stack.func_190926_b()) {
                    return CraftCheck.success();
                }
                if (this.tag != null) {
                    stack.func_77982_d(this.tag);
                }
                if ((inserted = ItemUtils.tryPlaceItemInInventory(stack.func_77946_l(), handler, true)) > 0 && chance.canProduce(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
                    return CraftCheck.success();
                }
                if (inserted > 0) {
                    int actual = ItemUtils.tryPlaceItemInInventory(stack.func_77946_l(), handler, false);
                    this.countIOBuffer -= actual;
                    if (this.countIOBuffer <= 0) {
                        return CraftCheck.success();
                    }
                    return CraftCheck.partialSuccess();
                }
                return CraftCheck.failure("craftcheck.failure.item.output.space");
            }
        }
        return CraftCheck.skipComponent();
    }

    public static enum ItemRequirementType {
        ITEMSTACKS,
        OREDICT,
        FUEL;

    }
}

