/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.command.ControllerCommandSender;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementDuration;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.util.PriorityProvider;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeCraftingContext {
    private static final Random RAND = new Random();
    private final ActiveMachineRecipe activeRecipe;
    private final TileMachineController machineController;
    private final ControllerCommandSender commandSender;
    private int currentCraftingTick = 0;
    private List<ProcessingComponent<?>> typeComponents = new LinkedList();
    private Map<RequirementType<?, ?>, List<RecipeModifier>> modifiers = new HashMap();
    private List<ComponentOutputRestrictor> currentRestrictions = Lists.newArrayList();

    public RecipeCraftingContext(ActiveMachineRecipe activeRecipe, TileMachineController controller) {
        this.activeRecipe = activeRecipe;
        this.machineController = controller;
        this.commandSender = new ControllerCommandSender(this.machineController);
    }

    public TileMachineController getMachineController() {
        return this.machineController;
    }

    public MachineRecipe getParentRecipe() {
        return this.activeRecipe.getRecipe();
    }

    public ActiveMachineRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    public void setCurrentCraftingTick(int currentCraftingTick) {
        this.currentCraftingTick = currentCraftingTick;
    }

    public int getCurrentCraftingTick() {
        return this.currentCraftingTick;
    }

    @Nonnull
    public List<RecipeModifier> getModifiers(RequirementType<?, ?> target) {
        return this.modifiers.computeIfAbsent(target, t -> new LinkedList());
    }

    public float getDurationMultiplier() {
        float dur = this.getParentRecipe().getRecipeTotalTickTime();
        float result = RecipeModifier.applyModifiers(this.getModifiers(RequirementTypesMM.REQUIREMENT_DURATION), RequirementTypesMM.REQUIREMENT_DURATION, null, dur, false);
        return dur / result;
    }

    public void addRestriction(ComponentOutputRestrictor restrictor) {
        this.currentRestrictions.add(restrictor);
    }

    public Iterable<ProcessingComponent<?>> getComponentsFor(ComponentRequirement<?, ?> requirement, @Nullable ComponentSelectorTag tag) {
        List validComponents = this.typeComponents.stream().filter(comp -> requirement.isValidComponent((ProcessingComponent<?>)comp, this)).collect(Collectors.toList());
        if (tag == null) {
            return Collections.unmodifiableList(validComponents);
        }
        return new PriorityProvider(validComponents, compList -> (ProcessingComponent)Iterators.tryFind(compList.iterator(), comp -> tag.equals(comp.getTag())).orNull());
    }

    public CraftingCheckResult ioTick(int currentTick) {
        ProcessingComponent<?> component;
        CraftCheck result;
        Iterator<ProcessingComponent<?>> iterator;
        ComponentRequirement.PerTick perTickRequirement;
        float durMultiplier = this.getDurationMultiplier();
        for (ComponentRequirement<?, ?> requirement : this.getParentRecipe().getCraftingRequirements()) {
            if (!(requirement instanceof ComponentRequirement.PerTick) || requirement.getActionType() == IOType.OUTPUT) continue;
            perTickRequirement = (ComponentRequirement.PerTick)requirement;
            perTickRequirement.resetIOTick(this);
            perTickRequirement.startIOTick(this, durMultiplier);
            iterator = this.getComponentsFor(requirement, requirement.getTag()).iterator();
            while (iterator.hasNext() && !(result = perTickRequirement.doIOTick(component = iterator.next(), this)).isSuccess()) {
            }
            CraftCheck result2 = perTickRequirement.resetIOTick(this);
            if (result2.isSuccess()) continue;
            CraftingCheckResult res = new CraftingCheckResult();
            res.addError(result2.getUnlocalizedMessage());
            return res;
        }
        for (ComponentRequirement<?, ?> requirement : this.getParentRecipe().getCraftingRequirements()) {
            if (!(requirement instanceof ComponentRequirement.PerTick) || requirement.getActionType() == IOType.INPUT) continue;
            perTickRequirement = (ComponentRequirement.PerTick)requirement;
            perTickRequirement.resetIOTick(this);
            perTickRequirement.startIOTick(this, durMultiplier);
            iterator = this.getComponentsFor(requirement, requirement.getTag()).iterator();
            while (iterator.hasNext() && !(result = perTickRequirement.doIOTick(component = iterator.next(), this)).isSuccess()) {
            }
            perTickRequirement.resetIOTick(this);
        }
        this.getParentRecipe().getCommandContainer().runTickCommands(this.commandSender, currentTick);
        return CraftingCheckResult.SUCCESS;
    }

    public void startCrafting() {
        this.startCrafting(RAND.nextLong());
    }

    public void startCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (ComponentRequirement<?, ?> requirement : this.getParentRecipe().getCraftingRequirements()) {
            requirement.startRequirementCheck(chance, this);
            for (ProcessingComponent<?> component : this.getComponentsFor(requirement, requirement.getTag())) {
                if (!requirement.startCrafting(component, this, chance)) continue;
                requirement.endRequirementCheck();
                break;
            }
            requirement.endRequirementCheck();
        }
        this.getParentRecipe().getCommandContainer().runStartCommands(this.commandSender);
    }

    public void finishCrafting() {
        this.finishCrafting(RAND.nextLong());
    }

    public void finishCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (ComponentRequirement<?, ?> requirement : this.getParentRecipe().getCraftingRequirements()) {
            requirement.startRequirementCheck(chance, this);
            for (ProcessingComponent<?> component : this.getComponentsFor(requirement, requirement.getTag())) {
                CraftCheck check = requirement.finishCrafting(component, this, chance);
                if (!check.isSuccess()) continue;
                requirement.endRequirementCheck();
                break;
            }
            requirement.endRequirementCheck();
        }
        this.getParentRecipe().getCommandContainer().runFinishCommands(this.commandSender);
    }

    public CraftingCheckResult canStartCrafting() {
        return this.canStartCrafting(req -> true);
    }

    public CraftingCheckResult canStartCrafting(Predicate<ComponentRequirement<?, ?>> requirementFilter) {
        this.currentRestrictions.clear();
        CraftingCheckResult result = new CraftingCheckResult();
        float successfulRequirements = 0.0f;
        List requirements = this.getParentRecipe().getCraftingRequirements().stream().filter(requirementFilter).collect(Collectors.toList());
        block0: for (ComponentRequirement requirement : requirements) {
            requirement.startRequirementCheck(ResultChance.GUARANTEED, this);
            Iterable<ProcessingComponent<?>> components = this.getComponentsFor(requirement, requirement.getTag());
            if (!Iterables.isEmpty(components)) {
                ArrayList errorMessages = Lists.newArrayList();
                for (ProcessingComponent<?> component : components) {
                    CraftCheck check = requirement.canStartCrafting(component, this, this.currentRestrictions);
                    if (check.isSuccess()) {
                        requirement.endRequirementCheck();
                        successfulRequirements += 1.0f;
                        continue block0;
                    }
                    if (check.isInvalid() || check.getUnlocalizedMessage().isEmpty()) continue;
                    errorMessages.add(check.getUnlocalizedMessage());
                }
                errorMessages.forEach(x$0 -> result.addError(x$0));
            } else {
                result.addError(requirement.getMissingComponentErrorMessage(requirement.getActionType()));
            }
            requirement.endRequirementCheck();
        }
        result.setValidity(successfulRequirements / (float)requirements.size());
        this.currentRestrictions.clear();
        return result;
    }

    public <T> void addComponent(MachineComponent<T> component, @Nullable ComponentSelectorTag tag) {
        this.typeComponents.add(new ProcessingComponent<T>(component, component.getContainerProvider(), tag));
    }

    public void addModifier(ModifierReplacement modifier) {
        List<RecipeModifier> modifiers = modifier.getModifiers();
        for (RecipeModifier mod : modifiers) {
            RequirementDuration target = mod.getTarget();
            if (target == null) {
                target = RequirementTypesMM.REQUIREMENT_DURATION;
            }
            this.modifiers.computeIfAbsent(target, t -> new LinkedList()).add(mod);
        }
    }

    public static class CraftingCheckResult {
        private static final CraftingCheckResult SUCCESS = new CraftingCheckResult();
        private Map<String, Integer> unlocErrorMessages = new HashMap<String, Integer>();
        private float validity = 0.0f;

        private CraftingCheckResult() {
        }

        private void setValidity(float validity) {
            this.validity = validity;
        }

        private void addError(String unlocError) {
            if (!unlocError.isEmpty()) {
                int count = this.unlocErrorMessages.getOrDefault(unlocError, 0);
                this.unlocErrorMessages.put(unlocError, ++count);
            }
        }

        public float getValidity() {
            return this.validity;
        }

        public List<String> getUnlocalizedErrorMessages() {
            return this.unlocErrorMessages.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        public boolean isFailure() {
            return !this.unlocErrorMessages.isEmpty();
        }
    }
}

