/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter;

import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class DynamicMachineRecipeAdapter
extends RecipeAdapter {
    private final DynamicMachine originalMachine;

    public DynamicMachineRecipeAdapter(@Nonnull ResourceLocation registryName, DynamicMachine originalMachine) {
        super(registryName);
        this.originalMachine = originalMachine;
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements) {
        String newIdentifier = owningMachineName.func_110624_b() + "." + owningMachineName.func_110623_a();
        ArrayList<MachineRecipe> recipesNew = new ArrayList<MachineRecipe>();
        for (MachineRecipe recipe : RecipeRegistry.getRegistry().getRecipesFor(this.originalMachine)) {
            MachineRecipe newRecipe = recipe.copy(res -> new ResourceLocation("modularmachinery", res.func_110623_a() + ".copy." + newIdentifier), owningMachineName, modifiers);
            for (ComponentRequirement<?, ?> additionalRequirement : additionalRequirements) {
                newRecipe.addRequirement(additionalRequirement.deepCopy());
            }
            recipesNew.add(newRecipe);
        }
        return recipesNew;
    }
}

