/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class IntegrationTypeHelper {
    public static void filterModIdComponents() {
        ArrayList<ComponentType> removableTypes = new ArrayList<ComponentType>();
        for (ComponentType type2 : RegistriesMM.COMPONENT_TYPE_REGISTRY) {
            String modid = type2.requiresModid();
            if (modid == null || Loader.isModLoaded((String)modid)) continue;
            ModularMachinery.log.info("[Modular Machinery] Removing componentType " + type2.getRegistryName() + " because " + modid + " is not loaded!");
            removableTypes.add(type2);
        }
        RegistriesMM.COMPONENT_TYPE_REGISTRY.unfreeze();
        removableTypes.forEach(type -> {
            ComponentType cfr_ignored_0 = (ComponentType)RegistriesMM.COMPONENT_TYPE_REGISTRY.remove(type.getRegistryName());
        });
    }

    public static void filterModIdRequirementTypes() {
        ArrayList<RequirementType> removableTypes = new ArrayList<RequirementType>();
        for (RequirementType type2 : RegistriesMM.REQUIREMENT_TYPE_REGISTRY) {
            String modid = type2.requiresModid();
            if (modid == null || Loader.isModLoaded((String)modid)) continue;
            ModularMachinery.log.info("[Modular Machinery] Removing requirementType " + type2.getRegistryName() + " because " + modid + " is not loaded!");
            removableTypes.add(type2);
        }
        RegistriesMM.REQUIREMENT_TYPE_REGISTRY.unfreeze();
        removableTypes.forEach(type -> {
            RequirementType cfr_ignored_0 = (RequirementType)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.remove(type.getRegistryName());
        });
    }

    public static RequirementType<?, ?> searchRequirementType(String name) {
        for (RequirementType type : RegistriesMM.REQUIREMENT_TYPE_REGISTRY) {
            ResourceLocation key = type.getRegistryName();
            if (!key.func_110623_a().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

