/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemMod;
import vazkii.arl.item.ItemModPickaxe;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.item.base.IPsiItem;
import vazkii.psi.common.item.tool.IPsimetalTool;

public class ItemPsimetalPickaxe
extends ItemModPickaxe
implements IPsimetalTool,
IPsiItem {
    public ItemPsimetalPickaxe(String name) {
        super(name, PsiAPI.PSIMETAL_TOOL_MATERIAL, new String[0]);
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        super.onBlockStartBreak(itemstack, pos, player);
        this.castOnBlockBreak(itemstack, player);
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.func_77958_k()) {
            damage = stack.func_77952_i();
        }
        super.setDamage(stack, damage);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        }
        return modifiers;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (!this.isEnabled(stack)) {
            name = name + ".broken";
        }
        return name;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!this.isEnabled(stack)) {
            return 1.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        String componentName = ItemMod.local((String)ISocketable.getSocketedItemName(stack, "psimisc.none"));
        TooltipHelper.addToTooltip(tooltip, "psimisc.spellSelected", componentName);
    }

    public boolean func_82789_a(ItemStack thisStack, @Nonnull ItemStack material) {
        return IPsimetalTool.isRepairableBy(material) || super.func_82789_a(thisStack, material);
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return false;
    }
}

