/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;

public interface ISpellAcceptor {
    @CapabilityInject(value=ISpellAcceptor.class)
    public static final Capability<ISpellAcceptor> CAPABILITY = null;

    public static boolean isAcceptor(ItemStack stack) {
        return stack.hasCapability(CAPABILITY, null);
    }

    public static boolean isContainer(ItemStack stack) {
        return ISpellAcceptor.isAcceptor(stack) && ISpellAcceptor.acceptor(stack).castableFromSocket();
    }

    public static boolean hasSpell(ItemStack stack) {
        return ISpellAcceptor.isContainer(stack) && ISpellAcceptor.acceptor(stack).containsSpell();
    }

    public static ISpellAcceptor acceptor(ItemStack stack) {
        return (ISpellAcceptor)stack.getCapability(CAPABILITY, null);
    }

    public void setSpell(EntityPlayer var1, Spell var2);

    public boolean castableFromSocket();

    @Nullable
    public Spell getSpell();

    public boolean containsSpell();

    public void castSpell(SpellContext var1);

    public double getCostModifier();

    public boolean isCADOnlyContainer();

    default public boolean requiresSneakForSpellSet() {
        return false;
    }
}

