/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.ModCheck;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.handler.SoundHandler;
import nc.init.NCBlocks;
import nc.init.NCSounds;
import nc.network.tile.FusionUpdatePacket;
import nc.radiation.RadiationHelper;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.tile.IGui;
import nc.tile.fluid.TileActiveCooler;
import nc.tile.generator.TileFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.inventory.ItemSorption;
import nc.util.BlockFinder;
import nc.util.BlockPosHelper;
import nc.util.CommonCapsHelper;
import nc.util.EnergyHelper;
import nc.util.Lang;
import nc.util.MaterialHelper;
import nc.util.NCUtil;
import nc.util.SoundHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers"), @Optional.Interface(iface="org.cyclops.commoncapabilities.api.capability.temperature.ITemperature", modid="commoncapabilities"), @Optional.Interface(iface="org.cyclops.commoncapabilities.api.capability.work.IWorker", modid="commoncapabilities")})
public class TileFusionCore
extends TileFluidGenerator
implements IGui<FusionUpdatePacket>,
SimpleComponent,
ITemperature,
IWorker {
    public static final double ROOM_TEMP = 0.298;
    public double processHeatVariable = 0.0;
    public double heat = 0.298;
    public double efficiency;
    public double cooling;
    public double heatChange;
    public int currentEnergyStored = 0;
    public int energyChange = 0;
    public int size = 1;
    public int complete;
    public String problem = RING_INCOMPLETE;
    public static final String RING_INCOMPLETE = Lang.localise("gui.container.fusion_core.ring_incomplete");
    public static final String RING_BLOCKED = Lang.localise("gui.container.fusion_core.ring_blocked");
    public static final String POWER_ISSUE = Lang.localise("gui.container.fusion_core.power_issue");
    public static final String INCORRECT_STRUCTURE = Lang.localise("gui.container.fusion_core.incorrect_structure");
    public static final String NO_PROBLEM = Lang.localise("gui.container.fusion_core.no_problem");
    public static final String NO_FUEL = Lang.localise("gui.container.fusion_core.empty");
    public boolean computerActivated = true;
    public int structureCount = 0;
    private BlockFinder finder;
    @SideOnly(value=Side.CLIENT)
    private List<SoundHandler.SoundInfo> activeSounds;
    private int soundCount = new Random().nextInt(20);
    private boolean refreshSoundInfo = true;

    private BlockFinder getFinder() {
        if (this.finder == null) {
            this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b);
        }
        return this.finder;
    }

    public TileFusionCore() {
        super("fusion_core", 2, 4, 0, TileFusionCore.defaultItemSorptions(new ItemSorption[0]), TileFusionCore.defaultTankCapacities(32000, 2, 4), TileFusionCore.defaultTankSorptions(2, 4), NCRecipes.fusion_valid_fluids, TileFusionCore.maxPower(), NCRecipes.fusion);
        this.setInputTanksSeparated(false);
    }

    private static int maxPower() {
        double max = 0.0;
        List recipes = NCRecipes.fusion.getRecipeList();
        for (ProcessorRecipe recipe : recipes) {
            if (recipe == null) continue;
            max = Math.max(max, recipe.getFusionComboPower());
        }
        return (int)Math.min(100.0 * max * NCConfig.fusion_base_power * (double)NCConfig.fusion_max_size, 2.147483647E9);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 3, 2));
    }

    @Override
    public void updateGenerator() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            if (this.structureCount == 0) {
                this.refreshMultiblock();
            }
            this.tickStructureCheck();
            this.energyChange = this.getEnergyStored() - this.currentEnergyStored;
            double previousHeat = this.heat;
            this.run();
            if (this.isHotEnough()) {
                this.doCooling();
            } else {
                this.plasma(false);
            }
            this.doHeating();
            this.heatChange = 1000.0 * (this.heat - previousHeat);
            if (this.overheat()) {
                return;
            }
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (wasProcessing != this.isProcessing) {
                if (this.isProcessing || this.recipeInfo == null) {
                    this.plasma(this.isProcessing);
                }
                this.updateBlockType();
                this.sendUpdateToAllPlayers();
            }
            if (this.isHotEnough()) {
                this.pushEnergy();
            }
            this.sendUpdateToListeningPlayers();
        } else {
            this.updateSounds();
        }
    }

    public int getComparatorStrength() {
        double strength = this.getAlternateComparator() ? this.heat / TileFusionCore.getMaxHeat() : this.efficiency / (double)NCConfig.fusion_comparator_max_efficiency;
        return (int)MathHelper.func_151237_a((double)(15.0 * strength), (double)0.0, (double)15.0);
    }

    public void tickStructureCheck() {
        ++this.structureCount;
        this.structureCount %= 4 * NCConfig.machine_update_rate;
    }

    public void refreshMultiblock() {
        this.setSize();
        if (NCConfig.fusion_active_cooling) {
            this.setCooling();
        }
        this.refreshActivity();
    }

    @Override
    public void updateBlockType() {
        super.updateBlockType();
        this.refreshMultiblock();
    }

    @Override
    public boolean checkIsRedstonePowered(World world, BlockPos dummyPos) {
        if (world.func_175640_z(this.field_174879_c)) {
            return true;
        }
        for (BlockPos ringPos : new BlockPosHelper(this.field_174879_c).squareRing(1, 0)) {
            if (!world.func_175640_z(ringPos)) continue;
            return true;
        }
        return false;
    }

    private boolean overheat() {
        if (this.heat >= TileFusionCore.getMaxHeat() && NCConfig.fusion_overheat) {
            this.meltdown();
            return true;
        }
        return false;
    }

    public void meltdown() {
        NCUtil.getLogger().info("Fusion Reactor meltdown at " + this.field_174879_c.toString() + "!");
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
        if (chunkSource != null) {
            RadiationHelper.addToSourceRadiation(chunkSource, 8.0 * this.baseProcessRadiation * (double)this.size * NCConfig.fusion_fuel_use * NCConfig.fusion_meltdown_radiation_multiplier);
        }
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175655_b(this.field_174879_c, false);
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150353_l.func_176223_P());
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
            this.field_145850_b.func_175656_a(pos, Blocks.field_150353_l.func_176203_a(1));
        }
        for (BlockPos pos : helper.squareTube(this.ringRadius(), 1)) {
            this.field_145850_b.func_175713_t(pos);
            this.field_145850_b.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSounds() {
        if (NCConfig.fusion_sound_volume == 0.0) {
            if (this.activeSounds != null) {
                this.stopSounds();
                this.activeSounds.clear();
                this.activeSounds = null;
            }
            return;
        }
        if (this.activeSounds == null) {
            this.activeSounds = new ArrayList<SoundHandler.SoundInfo>();
        }
        if (this.isProcessing && !this.func_145837_r()) {
            if (--this.soundCount > 0) {
                return;
            }
            if (this.refreshSoundInfo) {
                this.stopSounds();
                this.activeSounds.clear();
                if (this.size < 2) {
                    this.addSoundInfo(0, 1, 0);
                } else {
                    if (this.size > 4) {
                        this.addSoundInfo(0, 1, 0);
                    }
                    this.addSoundInfo(this.ringRadius(), 1, this.ringRadius());
                    this.addSoundInfo(this.ringRadius(), 1, -this.ringRadius());
                    this.addSoundInfo(-this.ringRadius(), 1, this.ringRadius());
                    this.addSoundInfo(-this.ringRadius(), 1, -this.ringRadius());
                    if (this.size > 8) {
                        this.addSoundInfo(this.ringRadius(), 1, 0);
                        this.addSoundInfo(-this.ringRadius(), 1, 0);
                        this.addSoundInfo(0, 1, this.ringRadius());
                        this.addSoundInfo(0, 1, -this.ringRadius());
                    }
                }
                this.refreshSoundInfo = false;
            }
            for (SoundHandler.SoundInfo activeSound : this.activeSounds) {
                if (activeSound == null || activeSound.sound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c(activeSound.sound)) continue;
                activeSound.sound = SoundHandler.startTileSound(NCSounds.fusion_run, activeSound.pos, (float)(0.35 * NCConfig.fusion_sound_volume), SoundHelper.getPitch(1.0));
            }
            this.soundCount = 116;
        } else {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        for (SoundHandler.SoundInfo activeSound : this.activeSounds) {
            if (activeSound == null) continue;
            SoundHandler.stopTileSound(activeSound.pos);
            activeSound.sound = null;
        }
        this.soundCount = 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void addSoundInfo(int x, int y, int z) {
        this.activeSounds.add(new SoundHandler.SoundInfo(null, new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)));
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSounds();
        }
    }

    @Override
    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessPower = this.defaultProcessPower;
            this.processHeatVariable = 1000.0;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = ((ProcessorRecipe)this.recipeInfo.getRecipe()).getFusionComboTime();
        this.baseProcessPower = ((ProcessorRecipe)this.recipeInfo.getRecipe()).getFusionComboPower();
        this.processHeatVariable = ((ProcessorRecipe)this.recipeInfo.getRecipe()).getFusionComboHeatVariable();
        this.baseProcessRadiation = ((ProcessorRecipe)this.recipeInfo.getRecipe()).getFusionComboRadiation();
        return true;
    }

    @Override
    public boolean isProcessing() {
        return this.readyToProcess() && !this.isDeactivated();
    }

    private boolean isDeactivated() {
        return this.getIsRedstonePowered() || !this.computerActivated;
    }

    @Override
    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed && this.isHotEnough() && this.complete == 1;
    }

    @Override
    public boolean canExtractEnergy(EnumFacing side) {
        return this.isHotEnough();
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return !this.isHotEnough();
    }

    public boolean isHotEnough() {
        return this.heat > 8000.0;
    }

    @Override
    public int getEUSourceTier() {
        return EnergyHelper.getEUTier(this.processPower);
    }

    @Override
    public int getEUSinkTier() {
        return 10;
    }

    public static double getMaxHeat() {
        return 2.0E7;
    }

    public int ringRadius() {
        return this.size + 2;
    }

    private static IBlockState plasmaState() {
        return FluidRegistry.getFluid((String)"plasma").getBlock().func_176223_P();
    }

    public void plasma(boolean createPlasma) {
        this.setSize();
        if (this.complete == 0) {
            return;
        }
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        if (createPlasma) {
            for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
                this.field_145850_b.func_175656_a(pos, TileFusionCore.plasmaState());
            }
        } else {
            for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
                this.field_145850_b.func_175698_g(pos);
            }
        }
    }

    private boolean findIdleElectromagnet(BlockPos pos) {
        return this.getFinder().find(pos, NCBlocks.fusion_electromagnet_idle, NCBlocks.fusion_electromagnet_transparent_idle);
    }

    private boolean findActiveElectromagnet(BlockPos pos) {
        return this.getFinder().find(pos, NCBlocks.fusion_electromagnet_active, NCBlocks.fusion_electromagnet_transparent_active);
    }

    private boolean findElectromagnet(BlockPos pos) {
        return this.getFinder().find(pos, NCBlocks.fusion_electromagnet_active, NCBlocks.fusion_electromagnet_transparent_active, NCBlocks.fusion_electromagnet_idle, NCBlocks.fusion_electromagnet_transparent_idle);
    }

    private boolean findAir(BlockPos pos) {
        Material mat = this.getFinder().getBlockState(pos).func_185904_a();
        return MaterialHelper.isReplaceable(mat) || this.findPlasma(pos);
    }

    private boolean findPlasma(BlockPos pos) {
        return this.getFinder().find(pos, TileFusionCore.plasmaState());
    }

    private TileActiveCooler findActiveCooler(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof TileActiveCooler) {
            return (TileActiveCooler)tile;
        }
        return null;
    }

    public void setSize() {
        int runningSize = 1;
        for (int r = 0; r <= NCConfig.fusion_max_size && this.getFinder().horizontalY(this.field_174879_c.func_177972_a(EnumFacing.UP), r + 2, NCBlocks.fusion_connector); ++r) {
            ++runningSize;
        }
        this.size = runningSize;
        BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
        for (BlockPos pos : helper.squareTube(this.ringRadius(), 1)) {
            if (this.findElectromagnet(pos)) continue;
            this.complete = 0;
            this.problem = RING_INCOMPLETE;
            return;
        }
        for (BlockPos pos : helper.squareRing(this.ringRadius(), 1)) {
            if (this.findAir(pos)) continue;
            this.complete = 0;
            this.problem = RING_BLOCKED;
            return;
        }
        for (BlockPos pos : helper.squareTube(this.ringRadius(), 1)) {
            if (this.findActiveElectromagnet(pos)) continue;
            this.complete = 0;
            this.problem = POWER_ISSUE;
            return;
        }
        this.complete = 1;
        this.problem = NO_PROBLEM;
    }

    public void run() {
        this.efficiency = this.efficiency();
        double heatChange = 0.0;
        if (this.isProcessing) {
            heatChange = NCConfig.fusion_heat_generation * (100.0 - 0.9 * this.efficiency) / 2.0;
            this.processPower = MathHelper.func_151237_a((double)this.efficiency, (double)0.0, (double)100.0) * NCConfig.fusion_base_power * (double)this.size * this.baseProcessPower;
            this.speedMultiplier = (double)this.size * NCConfig.fusion_fuel_use;
        } else {
            heatChange = 0.0;
            this.processPower = 0.0;
            this.speedMultiplier = 0.0;
            if (this.heat >= 0.29949) {
                this.heat -= this.heat / 100000.0 * Math.log10(1000.0 * (this.heat - 0.298));
            }
        }
        this.heat = this.heat + heatChange >= 0.298 ? (this.heat += heatChange) : 0.298;
    }

    public double efficiency() {
        if (!this.readyToProcess()) {
            return 0.0;
        }
        if (this.isHotEnough()) {
            double heatMK = this.heat / 1000.0;
            double z = 7.415 * (Math.exp(-heatMK / this.processHeatVariable) + Math.tanh(heatMK / this.processHeatVariable) - 1.0);
            return 100.0 * Math.pow(z, 2.0);
        }
        return 0.0;
    }

    public void doHeating() {
        if (!this.readyToProcess()) {
            double r = 1.0E-4 * (double)this.getEnergyStorage().getEnergyStored() / (double)this.ringRadius();
            this.getEnergyStorage().setEnergyStored(0);
            this.heat += r * NCConfig.fusion_heating_multiplier;
            this.setEnergyConnectionAll(EnergyConnection.IN);
            if (this.heat < 0.298) {
                this.heat = 0.298;
            }
        } else {
            this.setEnergyConnectionAll(EnergyConnection.OUT);
        }
    }

    public BlockPos getOpposite(BlockPos pos) {
        BlockPos relativePos = new BlockPos(pos.func_177958_n() - this.field_174879_c.func_177958_n(), pos.func_177956_o() - this.field_174879_c.func_177956_o(), pos.func_177952_p() - this.field_174879_c.func_177952_p());
        return this.getFinder().position(-relativePos.func_177958_n(), -relativePos.func_177956_o() + 2, -relativePos.func_177952_p());
    }

    public void setCooling() {
        if (this.complete == 1) {
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
            for (BlockPos pos : helper.squareTubeDiagonals(this.ringRadius(), 1)) {
                TileActiveCooler cooler = this.findActiveCooler(pos);
                if (cooler == null || cooler.getTanks().get(0).getFluidAmount() <= 0) continue;
                posList.add(pos);
            }
            if (posList.isEmpty()) {
                this.cooling = 0.0;
                return;
            }
            double cooled = 0.0;
            double currentHeat = this.heat;
            for (BlockPos pos : posList) {
                TileActiveCooler cooler = this.findActiveCooler(pos);
                if (cooler == null) continue;
                Tank tank = cooler.getTanks().get(0);
                int fluidAmount = Math.min(tank.getFluidAmount(), 4 * NCConfig.machine_update_rate * NCConfig.active_cooler_max_rate / 20);
                if (!(currentHeat > 0.298)) continue;
                double cool_mult = posList.contains(this.getOpposite(pos)) ? NCConfig.fusion_heat_generation * 4.0 : NCConfig.fusion_heat_generation;
                for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
                    if (!tank.getFluidName().equals(MetaEnums.CoolerType.values()[i].getFluidName())) continue;
                    cooled += NCConfig.fusion_active_cooling_rate[i - 1] * (double)fluidAmount * cool_mult / ((double)this.size * 1000.0);
                    break;
                }
                if (!((currentHeat -= cooled) > 0.298)) continue;
                tank.drain(fluidAmount, true);
            }
            this.cooling = Math.round(1000.0 * cooled / (double)(4 * NCConfig.machine_update_rate));
        }
    }

    public void doCooling() {
        double coolingkK = this.cooling / 1000.0;
        this.heat = this.heat - coolingkK < 0.298 ? 0.298 : (this.heat -= coolingkK);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("processPower", this.processPower);
        nbt.func_74780_a("speedMultiplier", this.speedMultiplier);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74780_a("cooling", this.cooling);
        nbt.func_74780_a("heatChange", this.heatChange);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74768_a("size", this.size);
        nbt.func_74768_a("complete", this.complete);
        nbt.func_74778_a("problem", this.problem);
        nbt.func_74757_a("computerActivated", this.computerActivated);
        nbt.func_74768_a("currentEnergyStored", this.currentEnergyStored);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.processPower = nbt.func_74769_h("processPower");
        this.speedMultiplier = nbt.func_74769_h("speedMultiplier");
        this.heat = nbt.func_74769_h("heat");
        this.cooling = nbt.func_74769_h("cooling");
        this.heatChange = nbt.func_74769_h("heatChange");
        this.efficiency = nbt.func_74769_h("efficiency");
        this.size = nbt.func_74762_e("size");
        this.complete = nbt.func_74762_e("complete");
        this.problem = nbt.func_74779_i("problem");
        this.computerActivated = nbt.func_74767_n("computerActivated");
        this.currentEnergyStored = nbt.func_74762_e("currentEnergyStored");
    }

    @Override
    public int getGuiID() {
        return 101;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public FusionUpdatePacket getGuiUpdatePacket() {
        return new FusionUpdatePacket(this.field_174879_c, this.time, this.getEnergyStored(), this.baseProcessTime, this.baseProcessPower, this.processPower, this.isProcessing, this.heat, this.efficiency, this.speedMultiplier, this.size, this.complete, this.cooling, this.heatChange, this.hasConsumed, this.computerActivated, this.problem, this.getTanks());
    }

    @Override
    public void onGuiPacket(FusionUpdatePacket message) {
        this.time = message.time;
        this.getEnergyStorage().setEnergyStored(message.energyStored);
        this.baseProcessTime = message.baseProcessTime;
        this.baseProcessPower = message.baseProcessPower;
        this.processPower = message.processPower;
        boolean wasProcessing = this.isProcessing;
        this.isProcessing = message.isProcessing;
        this.refreshSoundInfo = this.refreshSoundInfo || wasProcessing != this.isProcessing;
        this.heat = message.heat;
        this.efficiency = message.efficiency;
        this.speedMultiplier = message.speedMultiplier;
        this.size = message.size;
        this.complete = message.complete;
        this.cooling = message.cooling;
        this.heatChange = message.heatChange;
        this.hasConsumed = message.hasConsumed;
        this.computerActivated = message.computerActivated;
        this.problem = message.problem;
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (ModCheck.commonCapabilitiesLoaded() && (capability == CommonCapsHelper.CAPABILITY_TEMPERATURE || capability == CommonCapsHelper.CAPABILITY_WORKER)) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (ModCheck.commonCapabilitiesLoaded()) {
            if (capability == CommonCapsHelper.CAPABILITY_TEMPERATURE) {
                return (T)CommonCapsHelper.CAPABILITY_TEMPERATURE.cast((Object)this);
            }
            if (capability == CommonCapsHelper.CAPABILITY_WORKER) {
                return (T)CommonCapsHelper.CAPABILITY_WORKER.cast((Object)this);
            }
        }
        return super.getCapability(capability, side);
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_fusion_reactor";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.complete == 1};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.isProcessing};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isHotEnough(Context context, Arguments args) {
        return new Object[]{this.isHotEnough()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getProblem(Context context, Arguments args) {
        return new Object[]{this.problem};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getToroidSize(Context context, Arguments args) {
        return new Object[]{this.size};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getEnergyStored()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getMaxEnergyStored()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyChange(Context context, Arguments args) {
        return new Object[]{this.energyChange};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCurrentProcessTime(Context context, Arguments args) {
        return new Object[]{this.time};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getTemperature(Context context, Arguments args) {
        return new Object[]{1000.0 * this.heat};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxTemperature(Context context, Arguments args) {
        return new Object[]{1000.0 * TileFusionCore.getMaxHeat()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{this.efficiency};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFusionComboTime(Context context, Arguments args) {
        return new Object[]{this.recipeInfo != null ? this.baseProcessTime : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFusionComboPower(Context context, Arguments args) {
        return new Object[]{this.baseProcessPower};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFusionComboHeatVariable(Context context, Arguments args) {
        return new Object[]{this.recipeInfo != null ? this.processHeatVariable : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFirstFusionFuel(Context context, Arguments args) {
        return new Object[]{this.recipeInfo != null ? this.getFluidIngredients().get(0).getIngredientName() : NO_FUEL};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getSecondFusionFuel(Context context, Arguments args) {
        return new Object[]{this.recipeInfo != null ? this.getFluidIngredients().get(1).getIngredientName() : NO_FUEL};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessTime(Context context, Arguments args) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.recipeInfo != null ? (this.size == 0 ? this.baseProcessTime : this.baseProcessTime / (double)this.size) : 0.0;
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessPower(Context context, Arguments args) {
        return new Object[]{this.processPower};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessHeat(Context context, Arguments args) {
        return new Object[]{this.heatChange};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorCoolingRate(Context context, Arguments args) {
        return new Object[]{this.cooling};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        this.computerActivated = true;
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        this.computerActivated = false;
        return new Object[0];
    }

    @Optional.Method(modid="commoncapabilities")
    public double getTemperature() {
        return 1000.0 * this.heat;
    }

    @Optional.Method(modid="commoncapabilities")
    public double getMaximumTemperature() {
        return 1000.0 * TileFusionCore.getMaxHeat();
    }

    @Optional.Method(modid="commoncapabilities")
    public double getMinimumTemperature() {
        return 298.0;
    }

    @Optional.Method(modid="commoncapabilities")
    public double getDefaultTemperature() {
        return 298.0;
    }

    @Optional.Method(modid="commoncapabilities")
    public boolean hasWork() {
        return this.isProcessing;
    }

    @Optional.Method(modid="commoncapabilities")
    public boolean canWork() {
        return this.readyToProcess();
    }
}

