/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            this.addItemUse(list, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
            this.addInfoInBeta(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.allowTabletOfCupidity;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return false;
        }
        this.setUseCount(stack, this.getUseMax());
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        Location spawnPos;
        TileEntity tile = (TileEntity)Helper.getRandomInList(((WorldServer)world).field_147482_g.stream().filter(aTile -> aTile instanceof TileEntityMobSpawner || aTile instanceof TileEntityChest && ((TileEntityLockableLoot)aTile).field_184284_m != null).collect(Collectors.toList()));
        if (tile != null && Helper.isValidPos(world, tile.func_174877_v()) && !(spawnPos = new SpawnHelper((WorldServer)world, tile.func_174877_v()).findSpawnPlace(false)).isOrigin()) {
            CallbackHandler.addCallback(1, () -> {
                EntityPlayerMP newPlayer = Helper.teleportEntity(player, spawnPos);
                newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation(new Object[0]));
                EntityHelper.addAlignment(newPlayer, -1, 0.5f);
                Helper.addRandomPotion((EntityPlayer)newPlayer, 1200, true, true);
                ModTriggers.USE_CUPIDITY.trigger(newPlayer);
            });
            return true;
        }
        player.func_145747_a(LangKey.MESSAGE_TABLET_SEARCH_FAILED.getTranslation(new Object[0]));
        return true;
    }

    @Override
    public int getCastingCooldown() {
        return 18000;
    }
}

