/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;

public class ItemBlockGrave
extends ItemBlock {
    public ItemBlockGrave(Block block) {
        super(block);
        this.func_185043_a(new ResourceLocation("model_texture"), (stack, world, entity) -> ItemBlockGrave.isEngraved(stack) ? 0.1f : 0.0f);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String engravedName = ItemBlockGrave.getEngravedName(stack);
        if (engravedName.isEmpty()) {
            tooltip.add(LangKey.MESSAGE_ENGRAVABLE.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, StyleType.TOOLTIP_ITEM.func_150218_j() + "[" + LangKey.makeClientTranslation(Items.field_151042_j.func_77658_a() + ".name", new Object[0]).toLowerCase() + "]"));
        } else {
            tooltip.add(LangKey.MESSAGE_ENGRAVED.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, '\"' + engravedName + '\"'));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public String func_77653_i(ItemStack stack) {
        String engravedName = ItemBlockGrave.getEngravedName(stack);
        String itemName = LangKey.makeServerTranslation(stack.func_77977_a() + ".name", new Object[0]);
        return engravedName.isEmpty() ? itemName : LangKey.MESSAGE_ENGRAVED_ITEM.getServerTranslation(itemName);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        return world.func_180495_p(pos.func_177977_b()).func_185898_k() && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    public static boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (stack.func_77973_b() instanceof ItemBlockGrave) {
            NBTStackHelper.setString(stack, "engraved_name", engraved_name);
            return true;
        }
        return false;
    }

    public static boolean isEngraved(ItemStack stack) {
        return !ItemBlockGrave.getEngravedName(stack).isEmpty();
    }

    public static String getEngravedName(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockGrave ? NBTStackHelper.getString(stack, "engraved_name") : "";
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        assert (this.getRegistryName() != null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

