/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui.journal;

import com.agricraft.agricore.util.MathHelper;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.gui.AgriGuiWrapper;
import com.infinityraider.agricraft.gui.ComponentGui;
import com.infinityraider.agricraft.gui.component.ComponentRenderer;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import com.infinityraider.agricraft.gui.component.GuiComponentBuilder;
import com.infinityraider.agricraft.gui.journal.JournalPage;
import com.infinityraider.agricraft.gui.journal.JournalPageIntroduction;
import com.infinityraider.agricraft.gui.journal.JournalPageSeed;
import com.infinityraider.agricraft.gui.journal.JournalPageTitle;
import com.infinityraider.agricraft.items.ItemJournal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiJournal
extends ComponentGui {
    public static final int PAGE_WIDTH = 256;
    public static final int PAGE_HEIGHT = 192;
    public static final ResourceLocation LEFT_ARROW = new ResourceLocation("agricraft:textures/gui/journal/arrow_left.png");
    public static final ResourceLocation RIGHT_ARROW = new ResourceLocation("agricraft:textures/gui/journal/arrow_right.png");
    private static final int MINIMUM_PAGES = 2;
    private int currentPageNumber;
    private JournalPage currentPage;
    private final ItemStack journal;

    public GuiJournal(ItemStack journal) {
        super(256, 192, FAKE_CONTAINER);
        this.journal = journal;
    }

    @Override
    protected void onComponentGuiInit(AgriGuiWrapper wrapper) {
        this.clearComponents();
        this.clearBackgrounds();
        this.currentPage = this.getCurrentPage();
        this.addBackground(JournalPage.BACKGROUND);
        this.addBackground(this.currentPage.getForeground());
        this.addComponents(this.currentPage.getComponents());
        this.addNavArrows();
    }

    private JournalPage getCurrentPage() {
        switch (this.currentPageNumber) {
            case 0: {
                return new JournalPageTitle();
            }
            case 1: {
                return new JournalPageIntroduction();
            }
        }
        return new JournalPageSeed(this, this.getDiscoveredSeeds(), this.currentPageNumber - 2);
    }

    private List<IAgriPlant> getDiscoveredSeeds() {
        if (this.journal != null && this.journal.func_77973_b() instanceof ItemJournal) {
            return ((ItemJournal)this.journal.func_77973_b()).getDiscoveredSeeds(this.journal);
        }
        return new ArrayList<IAgriPlant>();
    }

    private int getNumberOfPages() {
        return 2 + this.getDiscoveredSeeds().size();
    }

    private void addNavArrows() {
        GuiComponent<ResourceLocation> leftArrow = new GuiComponentBuilder<ResourceLocation>(LEFT_ARROW, 1, 170, 32, 32).setRenderAction(ComponentRenderer::renderIconComponent).setMouseEnterAction((c, p) -> c.setVisable(this.currentPageNumber > 0)).setMouseLeaveAction((c, p) -> c.setVisable(false)).setMouseClickAction((c, p) -> this.incPage(-1)).setVisable(false).build();
        GuiComponent<ResourceLocation> rightArrow = new GuiComponentBuilder<ResourceLocation>(RIGHT_ARROW, 223, 170, 32, 32).setRenderAction(ComponentRenderer::renderIconComponent).setMouseEnterAction((c, p) -> c.setVisable(this.currentPageNumber < this.getNumberOfPages() - 1)).setMouseLeaveAction((c, p) -> c.setVisable(false)).setMouseClickAction((c, p) -> this.incPage(1)).setVisable(false).build();
        this.addComponent(leftArrow);
        this.addComponent(rightArrow);
    }

    public boolean switchPage(IAgriPlant plant) {
        int page = this.getDiscoveredSeeds().indexOf(plant) + 2;
        return page != -1 && this.setPage(page);
    }

    public boolean incPage(int inc) {
        return this.setPage(this.currentPageNumber + inc);
    }

    public boolean setPage(int page) {
        this.currentPageNumber = MathHelper.inRange(page, 0, this.getNumberOfPages() - 1);
        this.onGuiInit(null);
        return true;
    }
}

