/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.crafting;

import com.google.gson.JsonObject;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.agricraft.utility.StackHelper;
import java.util.Optional;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CustomWoodShapedRecipe
extends ShapedOreRecipe {
    public CustomWoodShapedRecipe(ResourceLocation id, ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(id, result, primer);
    }

    public boolean func_77569_a(InventoryCrafting ic, World world) {
        return super.func_77569_a(ic, world) && this.inferMaterial(ic).isPresent();
    }

    public ItemStack func_77572_b(InventoryCrafting ic) {
        ItemStack result = super.func_77572_b(ic);
        Optional<CustomWoodType> material = this.inferMaterial(ic);
        if (material.isPresent()) {
            NBTTagCompound tag = StackHelper.getTag(result);
            material.get().writeToNBT(tag);
            result.func_77982_d(tag);
        }
        return result;
    }

    public Optional<CustomWoodType> inferMaterial(InventoryCrafting ic) {
        for (int r = 0; r < ic.func_174922_i(); ++r) {
            for (int c = 0; c < ic.func_174923_h(); ++c) {
                ItemStack stack = ic.func_70463_b(r, c);
                Optional<CustomWoodType> material = CustomWoodTypeRegistry.getFromStack(stack);
                if (!material.isPresent()) continue;
                return material;
            }
        }
        return Optional.empty();
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe fake = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = fake.getRecipeWidth();
            primer.height = fake.getRecipeHeight();
            primer.input = fake.func_192400_c();
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            return new CustomWoodShapedRecipe(fake.getRegistryName(), fake.func_77571_b(), primer);
        }
    }
}

