/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.compat.computer.methods;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.compat.computer.methods.MethodParameter;
import com.infinityraider.agricraft.items.ItemJournal;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public final class MethodUtilities {
    public static boolean isSeedDiscovered(ItemStack journal, ItemStack seed) {
        if (journal == null || journal.func_77973_b() == null || !(journal.func_77973_b() instanceof ItemJournal)) {
            return false;
        }
        Optional<AgriSeed> s = AgriApi.getSeedRegistry().valueOf(seed);
        return s.isPresent() && ((ItemJournal)journal.func_77973_b()).isSeedDiscovered(journal, s.get().getPlant());
    }

    public static Optional<IAgriPlant> getCropPlant(ItemStack specimen) {
        return AgriApi.getSeedRegistry().valueOf(specimen).map(seed -> seed.getPlant());
    }

    public static Optional<IAgriPlant> getCropPlant(TileEntityCrop crop) {
        return Optional.ofNullable(crop.getSeed()).map(s -> s.getPlant());
    }

    public static String genSignature(String name, List<MethodParameter> parameters) {
        StringBuilder signature = new StringBuilder(name + "(");
        boolean separator = false;
        if (parameters != null) {
            for (MethodParameter parameter : parameters) {
                if (separator) {
                    signature.append(", ");
                } else {
                    separator = true;
                }
                signature.append(parameter.getName());
            }
        }
        signature.append(")");
        return signature.toString();
    }
}

