/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;
import pokefenn.totemic.api.lexicon.LexiconCategory;
import pokefenn.totemic.api.lexicon.LexiconEntry;
import pokefenn.totemic.client.gui.GuiLexicon;
import pokefenn.totemic.client.gui.GuiLexiconEntry;
import pokefenn.totemic.client.gui.IParented;
import pokefenn.totemic.client.gui.button.GuiButtonBack;
import pokefenn.totemic.client.gui.button.GuiButtonInvisible;
import pokefenn.totemic.client.gui.button.GuiButtonPage;

public class GuiLexiconIndex
extends GuiLexicon
implements IParented {
    LexiconCategory category;
    String title;
    int page = 0;
    GuiButton leftButton;
    GuiButton rightButton;
    GuiButton backButton;
    GuiLexicon parent;
    List<LexiconEntry> entriesToDisplay = new ArrayList<LexiconEntry>();
    int fx = 0;
    boolean swiped = false;

    public GuiLexiconIndex(LexiconCategory category) {
        this.category = category;
        this.title = I18n.func_135052_a((String)category.getUnlocalizedName(), (Object[])new Object[0]);
        this.parent = new GuiLexicon();
    }

    @Override
    void drawHeader() {
    }

    @Override
    String getTitle() {
        return this.title;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.backButton = new GuiButtonBack(12, this.left + this.guiWidth / 2 - 8, this.top + this.guiHeight + 2);
        this.field_146292_n.add(this.backButton);
        this.leftButton = new GuiButtonPage(13, this.left, this.top + this.guiHeight - 10, false);
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButtonPage(14, this.left + this.guiWidth - 18, this.top + this.guiHeight - 10, true);
        this.field_146292_n.add(this.rightButton);
        this.entriesToDisplay.clear();
        for (LexiconEntry entry : this.category.getEntries()) {
            this.entriesToDisplay.add(entry);
        }
        Collections.sort(this.entriesToDisplay);
        this.updatePageButtons();
        this.populateIndex();
    }

    @Override
    void populateIndex() {
        for (int i = this.page * 12; i < (this.page + 1) * 12; ++i) {
            LexiconEntry entry;
            GuiButtonInvisible button = (GuiButtonInvisible)((Object)this.field_146292_n.get(i - this.page * 12));
            LexiconEntry lexiconEntry = entry = i >= this.entriesToDisplay.size() ? null : this.entriesToDisplay.get(i);
            button.field_146126_j = entry != null ? "" + (entry.isPriority() ? TextFormatting.ITALIC : "") + I18n.func_135052_a((String)entry.getUnlocalizedName(), (Object[])new Object[0]) : "";
        }
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k >= 1337) {
            this.handleBookmark(par1GuiButton);
        } else {
            switch (par1GuiButton.field_146127_k) {
                case 12: {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                    break;
                }
                case 13: {
                    --this.page;
                    this.updatePageButtons();
                    this.populateIndex();
                    break;
                }
                case 14: {
                    ++this.page;
                    this.updatePageButtons();
                    this.populateIndex();
                    break;
                }
                default: {
                    int index = par1GuiButton.field_146127_k + this.page * 12;
                    if (index >= this.entriesToDisplay.size()) {
                        return;
                    }
                    LexiconEntry entry = this.entriesToDisplay.get(index);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiLexiconEntry(entry, this));
                }
            }
        }
    }

    public void updatePageButtons() {
        this.leftButton.field_146124_l = this.page != 0;
        this.rightButton.field_146124_l = this.page < (this.entriesToDisplay.size() - 1) / 12;
    }

    @Override
    public void setParent(GuiLexicon gui) {
        this.parent = gui;
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (button == 0 && Math.abs(x - this.fx) > 100 && this.field_146297_k.field_71474_y.field_85185_A && !this.swiped) {
            double swipe = (double)(x - this.fx) / Math.max(1.0, (double)time);
            if (swipe < 0.5) {
                this.nextPage();
                this.swiped = true;
            } else if (swipe > 0.5) {
                this.prevPage();
                this.swiped = true;
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        this.fx = par1;
        if (par3 == 1) {
            this.back();
        }
    }

    public void func_146274_d() throws IOException {
        int w;
        super.func_146274_d();
        if (Mouse.getEventButton() == 0) {
            this.swiped = false;
        }
        if ((w = Mouse.getEventDWheel()) < 0) {
            this.nextPage();
        } else if (w > 0) {
            this.prevPage();
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 203 || par2 == 200 || par2 == 201) {
            this.prevPage();
        } else if (par2 == 205 || par2 == 208 || par2 == 209) {
            this.nextPage();
        } else if (par2 == 14) {
            this.back();
        } else if (par2 == 199) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLexicon());
        }
        super.func_73869_a(par1, par2);
    }

    void back() {
        if (this.backButton.field_146124_l) {
            this.func_146284_a(this.backButton);
        }
    }

    void nextPage() {
        if (this.rightButton.field_146124_l) {
            this.func_146284_a(this.rightButton);
        }
    }

    void prevPage() {
        if (this.leftButton.field_146124_l) {
            this.func_146284_a(this.leftButton);
        }
    }
}

