/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.advancements.criterion;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.ceremony.Ceremony;

public class CeremonyTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("totemic", "perform_ceremony");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements advancements, ICriterionTrigger.Listener<Instance> listener) {
        this.listeners.computeIfAbsent(advancements, Listeners::new).add(listener);
    }

    public void func_192164_b(PlayerAdvancements advancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ls = this.listeners.get(advancements);
        if (ls != null) {
            ls.remove(listener);
            if (ls.isEmpty()) {
                this.listeners.remove(advancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        String name = JsonUtils.func_151200_h((JsonObject)json, (String)"ceremony");
        Ceremony ceremony = (Ceremony)TotemicRegistries.ceremonies().getValue(new ResourceLocation(name));
        if (ceremony == null) {
            throw new JsonSyntaxException("Unknown ceremony: '" + name + "'");
        }
        return new Instance(ceremony);
    }

    public void trigger(EntityPlayerMP player, Ceremony ceremony) {
        Listeners ls = this.listeners.get(player.func_192039_O());
        if (ls != null) {
            ls.trigger(ceremony);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.playerAdvancements = playerAdvancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Ceremony ceremony) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(ceremony)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final Ceremony ceremony;

        public Instance(Ceremony ceremony) {
            super(ID);
            this.ceremony = ceremony;
        }

        public boolean test(Ceremony ceremony) {
            return this.ceremony == ceremony;
        }
    }
}

