/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner.features;

import jaredbgreat.dldungeons.pieces.Shape;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.features.FeatureAdder;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.themes.Degree;

public class Cutout
extends FeatureAdder {
    public Cutout(Degree chance) {
        super(chance);
    }

    @Override
    public boolean addFeature(Dungeon dungeon, Room room) {
        boolean built = this.chance.use(dungeon.random);
        if (built) {
            this.buildFeature(dungeon, room);
        }
        return built;
    }

    @Override
    public void buildFeature(Dungeon dungeon, Room room) {
        int rotation = dungeon.random.nextInt(4);
        float dimX = (float)(room.endX - room.beginX) * (dungeon.random.nextFloat() * 0.2f + 0.1f);
        float dimZ = (float)(room.endX - room.beginX) * (dungeon.random.nextFloat() * 0.2f + 0.1f);
        float centerX = dungeon.random.nextInt(room.endX - room.beginX - 1) + room.beginX + 1;
        float centerZ = dungeon.random.nextInt(room.endZ - room.beginZ - 1) + room.beginZ + 1;
        float oppX = (float)room.endX - (centerX - (float)room.beginX);
        float oppZ = (float)room.endZ - (centerZ - (float)room.beginZ);
        if (room.sym.halfX) {
            dimX *= 2.0f;
            dimX /= 3.0f;
            oppX = (float)room.endX - (centerX - (float)room.beginX) / 2.0f;
            centerX = (centerX - (float)room.beginX) / 2.0f + (float)room.beginX;
        }
        if (room.sym.halfZ) {
            dimZ *= 2.0f;
            dimZ /= 3.0f;
            oppZ = (float)room.endZ - (centerZ - (float)room.beginZ) / 2.0f;
            centerZ = (centerZ - (float)room.beginZ) / 2.0f + (float)room.beginZ;
        }
        if (room.sym.doubler) {
            dimX = (float)((double)dimX * 0.7);
            dimZ = (float)((double)dimZ * 0.7);
        }
        oppX += 1.0f;
        oppZ += 1.0f;
        Shape[] which = !dungeon.complexity.use(dungeon.random) ? Shape.xgroup : Shape.allSolids[dungeon.random.nextInt(Shape.allSolids.length)];
        which[rotation].drawCutout(dungeon, room, centerX += 1.0f, centerZ += 1.0f, dimX, dimZ, false, false);
        switch (room.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = room.realX + (centerZ - room.realZ) / (float)(room.endZ - room.beginZ) * (float)(room.endX - room.beginX);
                oppZ = room.realZ + (centerX - room.realX) / (float)(room.endX - room.beginX) * (float)(room.endZ - room.beginZ);
                which[(rotation + 1) % 4].drawCutout(dungeon, room, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case TR2: {
                oppX = room.realX + (centerZ - room.realZ) / (float)(room.endZ - room.beginZ) * (float)(room.endX - room.beginX);
                oppZ = room.realZ + (centerX - room.realX) / (float)(room.endX - room.beginX) * (float)(room.endZ - room.beginZ);
                oppZ = (float)room.endZ - (oppZ - (float)room.beginZ);
                which[(rotation + 1) % 4].drawCutout(dungeon, room, oppX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case X: {
                which[rotation].drawCutout(dungeon, room, oppX, centerZ, dimX, dimZ, true, false);
                break;
            }
            case Z: {
                which[rotation].drawCutout(dungeon, room, centerX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case XZ: {
                which[rotation].drawCutout(dungeon, room, oppX, centerZ, dimX, dimZ, true, false);
                which[rotation].drawCutout(dungeon, room, centerX, oppZ, dimX, dimZ, false, true);
                which[rotation].drawCutout(dungeon, room, oppX, oppZ, dimX, dimZ, true, true);
                break;
            }
            case R: {
                which[(rotation + 2) % 4].drawCutout(dungeon, room, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case SW: {
                float swX1 = room.realX + (centerZ - room.realZ) / (float)(room.endZ - room.beginZ) * (float)(room.endX - room.beginX);
                float swZ1 = room.realZ + (centerX - room.realX) / (float)(room.endX - room.beginX) * (float)(room.endZ - room.beginZ);
                float swX2 = room.realX + (oppZ - room.realZ) / (float)(room.endZ - room.beginZ) * (float)(room.endX - room.beginX);
                float swZ2 = room.realZ + (oppX - room.realX) / (float)(room.endX - room.beginX) * (float)(room.endZ - room.beginZ);
                which[(rotation + 1) % 4].drawCutout(dungeon, room, swX2, swZ1, dimX, dimZ, false, false);
                which[(rotation + 3) % 4].drawCutout(dungeon, room, swX1, swZ2, dimX, dimZ, false, false);
                which[(rotation + 2) % 4].drawCutout(dungeon, room, oppX, oppZ, dimX, dimZ, false, false);
            }
        }
    }
}

