/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.network;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.network.DimensionSyncPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSyncDimensions
implements IMessage {
    private List<DimensionConfigEntry> dimensions = new ArrayList<DimensionConfigEntry>();

    public MessageSyncDimensions() {
    }

    public MessageSyncDimensions(Collection<DimensionConfigEntry> entries) {
        this.dimensions.addAll(entries);
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        this.dimensions.clear();
        for (int i = 0; i < count; ++i) {
            DimensionConfigEntry entry = DimensionConfigEntry.fromByteBuf(buf);
            if (entry == null) continue;
            this.dimensions.add(entry);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensions.size());
        for (DimensionConfigEntry entry : this.dimensions) {
            entry.writeToByteBuf(buf);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSyncDimensions, IMessage> {
        public IMessage onMessage(final MessageSyncDimensions message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                JustEnoughDimensions.logger.error("Wrong side in MessageSyncDimensions: " + ctx.side);
                return null;
            }
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc == null) {
                JustEnoughDimensions.logger.error("Minecraft was null in MessageSyncDimensions");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message);
                }
            });
            return null;
        }

        protected void processMessage(MessageSyncDimensions message) {
            String str = DimensionSyncPacket.registerDimensions(message.dimensions);
            JustEnoughDimensions.logInfo("MessageSyncDimensions: Registered dimensions: '" + str + "'", new Object[0]);
        }
    }
}

