/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework.widgets;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import org.dave.compactmachines3.gui.framework.ISelectable;
import org.dave.compactmachines3.gui.framework.event.MouseClickEvent;
import org.dave.compactmachines3.gui.framework.event.MouseScrollEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;
import org.dave.compactmachines3.gui.framework.widgets.Widget;
import org.dave.compactmachines3.gui.framework.widgets.WidgetPanel;
import org.dave.compactmachines3.utility.Logz;

public class WidgetList
extends WidgetPanel {
    public int padding = 2;
    public int scrollLines = 1;
    private int lineOffset = 0;
    private int lastVisibleLine = 0;
    protected int selected = -1;

    public WidgetList() {
        this.addListener(MouseScrollEvent.class, (event, widget) -> {
            if (event.up) {
                this.scrollUp();
            } else {
                this.scrollDown();
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public void scrollUp() {
        this.lineOffset = Math.max(0, this.lineOffset - this.scrollLines);
        this.updateWidgets();
    }

    public void scrollDown() {
        if (this.lastVisibleLine == this.getTotalLines() - 1) {
            return;
        }
        this.lineOffset += this.scrollLines;
        this.updateWidgets();
    }

    public void deselect() {
        this.selected = -1;
    }

    public int getTotalLines() {
        return this.children.size();
    }

    public int getLineHeight(int line) {
        if (line >= this.children.size()) {
            return 0;
        }
        return ((Widget)this.children.get((int)line)).height;
    }

    @Override
    public void draw(GuiScreen screen) {
        int backgroundColor = -13421773;
        int borderColor = -16777216;
        int selectedBackgroundColor = -11184811;
        Gui.func_73734_a((int)0, (int)0, (int)this.width, (int)this.height, (int)borderColor);
        Gui.func_73734_a((int)1, (int)1, (int)(this.width - 1), (int)(this.height - 1), (int)backgroundColor);
        if (this.selected >= this.lineOffset && this.selected <= this.lastVisibleLine) {
            int yOffset = 0;
            for (int line = this.lineOffset; line < this.selected; ++line) {
                Widget widget = (Widget)this.children.get(line);
                yOffset += widget.height;
            }
            Widget selectedWidget = (Widget)this.children.get(this.selected);
            Gui.func_73734_a((int)1, (int)(yOffset + 1), (int)(this.width - 1), (int)(yOffset + 1 + selectedWidget.height - 1), (int)selectedBackgroundColor);
        }
        super.draw(screen);
    }

    @Override
    @Deprecated
    public void add(Widget widget) {
        Logz.warn("Calling unused method to add widgets to list! Use WidgetList#addListEntry instead!", new Object[0]);
    }

    public <T extends Widget> void addListEntry(T widget) {
        if (((Widget)widget).height <= 0) {
            Logz.warn("Heightless widget [%s] added to list. This will cause problems.", widget);
        }
        if (((Widget)widget).height > this.height) {
            Logz.warn("List has an entry larger than the list itself. This will cause problems.", widget);
        }
        int line = this.children.size();
        ((Widget)widget).addListener(MouseClickEvent.class, (event, clickedWidget) -> {
            if (this.selected == line) {
                this.selected = -1;
                ((ISelectable)((Object)widget)).setSelected(false);
            } else {
                Widget oldSelection;
                if (this.selected != -1 && (oldSelection = (Widget)this.children.get(this.selected)) instanceof ISelectable) {
                    ((ISelectable)((Object)oldSelection)).setSelected(false);
                }
                this.selected = line;
                ((ISelectable)((Object)widget)).setSelected(true);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        super.add((Widget)widget);
        this.updateWidgets();
    }

    public void updateWidgets() {
        int visibleHeight = this.padding;
        boolean exceededListHeight = false;
        for (int line = 0; line < this.children.size(); ++line) {
            Widget widget = (Widget)this.children.get(line);
            if (line < this.lineOffset) {
                widget.setVisible(false);
                continue;
            }
            if (visibleHeight + widget.height > this.height - this.padding) {
                exceededListHeight = true;
            }
            if (exceededListHeight) {
                widget.setVisible(false);
                continue;
            }
            if (line == this.selected && widget instanceof ISelectable) {
                ((ISelectable)((Object)widget)).setSelected(true);
            }
            widget.setVisible(true);
            widget.setY(visibleHeight);
            widget.setX(this.padding);
            visibleHeight += widget.height;
            this.lastVisibleLine = line;
        }
    }
}

