/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import net.theawesomegem.blockdropstweaker.networking.PrimaryPacketHandler;
import net.theawesomegem.blockdropstweaker.networking.packet.PacketTextCopyC;

public class ChatUtil {
    public static final String copyCommandBase = "/bd copy ";
    public static final ITextComponent EMPTY_TEXTMESSAGE = new TextComponentString("");

    public static void sendMessageWithCopy(EntityPlayer player, String holeMessage, String copyMessage) {
        player.func_145747_a(ChatUtil.getCopyMessage(holeMessage, copyMessage));
    }

    static void copyCommandRun(ICommandSender sender, String[] args) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            message.append(args[i]);
            if (i == args.length - 1) continue;
            message.append(" ");
        }
        if (sender.func_174793_f() instanceof EntityPlayer) {
            ChatUtil.copyStringPlayer((EntityPlayer)sender.func_174793_f(), message.toString());
            sender.func_145747_a((ITextComponent)new TextComponentString(message.toString() + " was copied. Press Ctrl+V to paste."));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Only a player can execute this command."));
        }
    }

    static void copyStringPlayer(EntityPlayer player, String s) {
        if (player instanceof EntityPlayerMP) {
            PrimaryPacketHandler.INSTANCE.sendTo((IMessage)new PacketTextCopyC(s), (EntityPlayerMP)player);
        }
    }

    public static ITextComponent getClickableCommandText(String message, String command, boolean runDirectly) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(runDirectly ? ClickEvent.Action.RUN_COMMAND : ClickEvent.Action.SUGGEST_COMMAND, command);
        style.func_150241_a(click);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to execute [\u00a76" + command + "\u00a7r]"));
        style.func_150209_a(hoverEvent);
        return new TextComponentString(message).func_150255_a(style);
    }

    public static ITextComponent getClickableBrowserLinkText(String message, String url) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
        style.func_150241_a(click);
        style.func_150238_a(TextFormatting.AQUA);
        style.func_150228_d(Boolean.valueOf(true));
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to Open [\u00a76" + url + "\u00a7r]"));
        style.func_150209_a(hoverEvent);
        return new TextComponentString(message).func_150255_a(style);
    }

    public static List<String> getOreDictOfItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new ArrayList<String>();
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> names = new ArrayList<String>();
        for (int id : ids) {
            names.add(OreDictionary.getOreName((int)id));
        }
        return names;
    }

    public static RayTraceResult getPlayerLookat(EntityPlayer player, double range) {
        Vec3d eyes = player.func_174824_e(1.0f);
        return player.func_130014_f_().func_72933_a(eyes, eyes.func_178787_e(player.func_70040_Z().func_186678_a(range)));
    }

    public static ITextComponent getFileOpenText(String message, String filepath) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_FILE, filepath);
        style.func_150241_a(click);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to open [\u00a76" + filepath + "\u00a7r]"));
        style.func_150209_a(hoverEvent);
        return new TextComponentString(message).func_150255_a(style);
    }

    public static ITextComponent getNormalMessage(String message) {
        return new TextComponentString(message);
    }

    public static ITextComponent getCopyMessage(String message, String copyMessage) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, copyCommandBase + copyMessage);
        style.func_150241_a(click);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to copy [\u00a76" + copyMessage + "\u00a7r]"));
        style.func_150209_a(hoverEvent);
        return new TextComponentString(message).func_150255_a(style);
    }

    public static String getItemStackID(Item item) {
        if (item == null) {
            return "EMPTY";
        }
        return item.getRegistryName().toString();
    }

    public static void copyMessage(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            PrimaryPacketHandler.INSTANCE.sendTo((IMessage)new PacketTextCopyC(message), (EntityPlayerMP)player);
        }
    }
}

