/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.event;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.FortuneQuantityData;
import net.theawesomegem.blockdropstweaker.hook.GameStageHook;
import net.theawesomegem.blockdropstweaker.hook.TConstructHook;

public class EventHandlerCommon {
    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent e) {
        int metadata;
        String blockID;
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        IBlockState blockState = e.getState();
        Block block = blockState.func_177230_c();
        BlockDropData blockDropData = ConfigurationHandler.getBlockDropData(block, blockID = block.getRegistryName().toString(), metadata = block.func_176201_c(blockState));
        if (blockDropData == null) {
            return;
        }
        e.setExpToDrop(0);
    }

    @SubscribeEvent
    public void onHarvestBlock(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer player;
        ItemStack itemStack;
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        ItemStack toolUsed = ItemStack.field_190927_a;
        if (e.getHarvester() != null && e.getHarvester().func_70089_S() && !(itemStack = (player = e.getHarvester()).func_184614_ca()).func_190926_b()) {
            toolUsed = itemStack.func_77946_l();
        }
        IBlockState blockState = e.getState();
        Block block = blockState.func_177230_c();
        String blockID = block.getRegistryName().toString();
        int metadata = block.func_176201_c(blockState);
        Random random = world.field_73012_v;
        int exp = 0;
        BlockDropData blockDropData = ConfigurationHandler.getBlockDropData(block, blockID, metadata);
        if (blockDropData == null) {
            return;
        }
        if (!GameStageHook.isGameStage(e.getHarvester(), blockDropData)) {
            return;
        }
        if (!TConstructHook.isModifier(toolUsed, blockDropData)) {
            return;
        }
        if (!TConstructHook.isTrait(toolUsed, blockDropData)) {
            return;
        }
        if (!this.hasEnchantment(toolUsed, blockDropData)) {
            return;
        }
        if (!EventHandlerCommon.hasNBT(toolUsed, blockDropData)) {
            return;
        }
        int yPos = e.getPos().func_177956_o();
        if (yPos < blockDropData.minYLevel || yPos > blockDropData.maxYLevel) {
            return;
        }
        if (!this.isToolAllowed(toolUsed, blockDropData)) {
            return;
        }
        Biome biome = world.func_180494_b(e.getPos());
        String biomeID = biome.getRegistryName().toString();
        if (!this.isBiomeAllowed(biomeID, blockDropData)) {
            return;
        }
        int fortuneLevel = e.getFortuneLevel();
        int chance = blockDropData.fortunechance.get(fortuneLevel);
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        ItemStack silkTouchItem = ItemStack.field_190927_a;
        if (!blockDropData.replace) {
            dropList.addAll(e.getDrops());
        }
        if (e.isSilkTouching() && blockDropData.allowsilktouch) {
            silkTouchItem = this.getSilkTouchDrop(block, blockState);
        }
        ItemStack itemToRemove = ItemStack.field_190927_a;
        for (ItemStack itemStack2 : dropList) {
            if (!itemStack2.func_77969_a(silkTouchItem)) continue;
            itemToRemove = itemStack2;
        }
        if (!itemToRemove.func_190926_b()) {
            dropList.remove(itemToRemove);
        }
        if (!silkTouchItem.func_190926_b()) {
            dropList.add(silkTouchItem);
        }
        e.getDrops().clear();
        Map.Entry<List<ItemStack>, Integer> dropExpEntry = this.getDrops(random, blockDropData, fortuneLevel, toolUsed, yPos, biomeID, e.getHarvester());
        dropList.addAll((Collection)dropExpEntry.getKey());
        int perc = MathHelper.func_76136_a((Random)random, (int)0, (int)100);
        if (chance >= perc) {
            exp += MathHelper.func_76136_a((Random)world.field_73012_v, (int)blockDropData.minExp, (int)blockDropData.maxExp);
            if ((exp += dropExpEntry.getValue().intValue()) > 0) {
                block.func_180637_b(world, e.getPos(), exp);
            }
            e.getDrops().addAll(dropList);
        } else if (blockDropData.dropsilktouchalways && !silkTouchItem.func_190926_b()) {
            e.getDrops().add(silkTouchItem);
        }
    }

    public static boolean hasNBT(ItemStack toolItem, DropData dropData) {
        if (dropData.nbtList.isEmpty() && dropData.nbtBlacklist) {
            return true;
        }
        if (toolItem.func_190926_b()) {
            return dropData.nbtBlacklist;
        }
        if (!toolItem.func_77942_o()) {
            return dropData.nbtBlacklist;
        }
        boolean nbtExist = false;
        for (String nbt : dropData.nbtList) {
            if (!toolItem.func_77978_p().func_74764_b(nbt)) continue;
            nbtExist = true;
            break;
        }
        if (dropData.nbtBlacklist && nbtExist) {
            return false;
        }
        return dropData.nbtBlacklist || nbtExist;
    }

    public static boolean hasNBT(ItemStack toolItem, BlockDropData blockDropData) {
        if (blockDropData.nbtList.isEmpty() && blockDropData.nbtBlacklist) {
            return true;
        }
        if (toolItem.func_190926_b()) {
            return blockDropData.nbtBlacklist;
        }
        if (!toolItem.func_77942_o()) {
            return blockDropData.nbtBlacklist;
        }
        boolean nbtExist = false;
        for (String nbt : blockDropData.nbtList) {
            if (!toolItem.func_77978_p().func_74764_b(nbt)) continue;
            nbtExist = true;
            break;
        }
        if (blockDropData.nbtBlacklist && nbtExist) {
            return false;
        }
        return blockDropData.nbtBlacklist || nbtExist;
    }

    private boolean hasEnchantment(ItemStack toolItem, DropData dropData) {
        if (dropData.enchantmentList.isEmpty() && dropData.enchantmentBlacklist) {
            return true;
        }
        if (toolItem.func_190926_b()) {
            return dropData.enchantmentBlacklist;
        }
        if (!toolItem.func_77948_v()) {
            return dropData.enchantmentBlacklist;
        }
        boolean enchantmentExist = false;
        for (String enchantment : dropData.enchantmentList) {
            Enchantment enchantmentObj = Enchantment.func_180305_b((String)enchantment);
            if (enchantmentObj == null || EnchantmentHelper.func_77506_a((Enchantment)enchantmentObj, (ItemStack)toolItem) <= 0) continue;
            enchantmentExist = true;
            break;
        }
        if (dropData.enchantmentBlacklist && enchantmentExist) {
            return false;
        }
        return dropData.enchantmentBlacklist || enchantmentExist;
    }

    private boolean hasEnchantment(ItemStack toolItem, BlockDropData blockDropData) {
        if (blockDropData.enchantmentList.isEmpty() && blockDropData.enchantmentBlacklist) {
            return true;
        }
        if (toolItem.func_190926_b()) {
            return blockDropData.enchantmentBlacklist;
        }
        if (!toolItem.func_77948_v()) {
            return blockDropData.enchantmentBlacklist;
        }
        boolean enchantmentExist = false;
        for (String enchantment : blockDropData.enchantmentList) {
            Enchantment enchantmentObj = Enchantment.func_180305_b((String)enchantment);
            if (enchantmentObj == null || EnchantmentHelper.func_77506_a((Enchantment)enchantmentObj, (ItemStack)toolItem) <= 0) continue;
            enchantmentExist = true;
            break;
        }
        if (blockDropData.enchantmentBlacklist && enchantmentExist) {
            return false;
        }
        return blockDropData.enchantmentBlacklist || enchantmentExist;
    }

    private boolean isToolAllowed(ItemStack toolItem, BlockDropData blockDropData) {
        Iterator<String> iterator = blockDropData.tools.iterator();
        if (iterator.hasNext()) {
            String minedWith = iterator.next();
            if (blockDropData.toolsBlacklist) {
                return !this.isUsingItem(toolItem, minedWith);
            }
            return this.isUsingItem(toolItem, minedWith);
        }
        return blockDropData.toolsBlacklist;
    }

    private boolean isBiomeAllowed(String biomeID, BlockDropData blockDropData) {
        if (blockDropData.biomeBlacklist) {
            return !blockDropData.biomes.contains(biomeID);
        }
        return blockDropData.biomes.contains(biomeID);
    }

    private Map.Entry<List<ItemStack>, Integer> getDrops(Random random, BlockDropData blockDropData, int fortune, ItemStack heldItem, int yLevel, String biomeID, EntityPlayer harvester) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (blockDropData.dropdatalist.isEmpty()) {
            return new AbstractMap.SimpleEntry<List<ItemStack>, Integer>(new ArrayList(), 0);
        }
        int exp = 0;
        for (DropData dropData : blockDropData.dropdatalist) {
            int perc;
            int chance;
            FortuneQuantityData fortuneQuantityData;
            Item item = Item.func_111206_d((String)dropData.id);
            if (item == null || (fortuneQuantityData = dropData.fortunequantitymap.get(fortune)) == null || (chance = dropData.fortunechancemap.get(fortune).intValue()) < (perc = MathHelper.func_76136_a((Random)random, (int)1, (int)100)) || yLevel < dropData.minYLevel || yLevel > dropData.maxYLevel || !this.isToolAllowed(heldItem, dropData) || !this.isBiomeAllowed(biomeID, dropData) || !GameStageHook.isGameStage(harvester, dropData) || !TConstructHook.isModifier(heldItem, dropData) || !TConstructHook.isTrait(heldItem, dropData) || !this.hasEnchantment(heldItem, dropData) || !EventHandlerCommon.hasNBT(heldItem, blockDropData)) continue;
            int quantity = MathHelper.func_76136_a((Random)random, (int)fortuneQuantityData.minquantity, (int)fortuneQuantityData.maxquantity);
            ItemStack itemStack = new ItemStack(item, quantity, dropData.metadata);
            if (dropData.exclusive) {
                drops.clear();
                drops.add(itemStack);
                exp = MathHelper.func_76136_a((Random)random, (int)dropData.minExp, (int)dropData.maxExp);
                break;
            }
            exp += MathHelper.func_76136_a((Random)random, (int)dropData.minExp, (int)dropData.maxExp);
            drops.add(itemStack);
        }
        return new AbstractMap.SimpleEntry<List<ItemStack>, Integer>(drops, exp);
    }

    private boolean isToolAllowed(ItemStack toolItem, DropData dropData) {
        Iterator<String> iterator = dropData.tools.iterator();
        if (iterator.hasNext()) {
            String minedWith = iterator.next();
            if (dropData.toolsBlacklist) {
                return !this.isUsingItem(toolItem, minedWith);
            }
            return this.isUsingItem(toolItem, minedWith);
        }
        return dropData.toolsBlacklist;
    }

    private boolean isBiomeAllowed(String biomeID, DropData dropData) {
        if (dropData.biomeBlacklist) {
            return !dropData.biomes.contains(biomeID);
        }
        return dropData.biomes.contains(biomeID);
    }

    private ItemStack getSilkTouchDrop(Block block, IBlockState state) {
        Item item = Item.func_150898_a((Block)block);
        int i = 0;
        if (item.func_77614_k()) {
            i = block.func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    private boolean isUsingItem(ItemStack heldItem, String itemData) {
        if (heldItem.func_190926_b()) {
            return false;
        }
        String[] itemArray = itemData.split(",");
        String itemID = itemArray[0];
        String metadata = itemArray[1];
        Item item = Item.func_111206_d((String)itemID);
        if (item == null) {
            return false;
        }
        if (metadata.equals("*")) {
            ItemStack itemStack = new ItemStack(item, heldItem.func_190916_E());
            return !itemStack.func_190926_b() && itemStack.func_77973_b().equals(heldItem.func_77973_b());
        }
        ItemStack itemStack = new ItemStack(item, heldItem.func_190916_E(), Integer.parseInt(metadata));
        return ItemStack.func_179545_c((ItemStack)heldItem, (ItemStack)itemStack);
    }
}

