/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.select;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropSelectCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "select";
    }

    @Override
    protected String getCommandPath() {
        return "drop.select";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        String itemData = args[0];
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        String blockData = playerData.getSelectedBlock();
        BlockDropData blockDropData = ConfigurationHandler.blockDropMap.get(blockData);
        if (blockData == null || blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a block first using '/bd block select'"));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, itemData);
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The drop does not exist. Please add it first to configure."));
            return;
        }
        playerData.setSelectedDrop(itemData);
        player.func_145747_a(ChatUtil.getNormalMessage("Selected Drop:" + itemData + " for block:" + blockData));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (!(sender instanceof EntityPlayer)) {
            return tabList;
        }
        EntityPlayer player = (EntityPlayer)sender;
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        String blockData = playerData.getSelectedBlock();
        if (blockData != null) {
            BlockDropData blockDropData = ConfigurationHandler.blockDropMap.get(blockData);
            for (DropData dropData : blockDropData.dropdatalist) {
                tabList.add(dropData.id + "," + dropData.metadata);
            }
        }
        return DropSelectCommand.func_175762_a((String[])args, tabList);
    }
}

