/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.get;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.FortuneQuantityData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropGetCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "get";
    }

    @Override
    protected String getCommandPath() {
        return "drop.get";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        boolean isFortuneQuantity;
        BlockDropData blockDropData;
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a block first using '/bd block select'"));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        boolean isFortuneChance = args.length >= 1 && args[0].equals("fortunechance");
        boolean bl = isFortuneQuantity = args.length >= 1 && args[0].equals("fortunequantity");
        if (isFortuneChance) {
            player.func_145747_a(ChatUtil.getNormalMessage("---Fortune Chance---"));
            for (Map.Entry<Integer, Integer> fortuneChanceEntry : dropData.fortunechancemap.entrySet()) {
                player.func_145747_a(ChatUtil.getNormalMessage("Level " + fortuneChanceEntry.getKey() + "=" + fortuneChanceEntry.getValue() + "%"));
            }
            player.func_145747_a(ChatUtil.getNormalMessage("-------------------"));
            return;
        }
        if (isFortuneQuantity) {
            player.func_145747_a(ChatUtil.getNormalMessage("---Fortune Quantity---"));
            for (Map.Entry<Integer, FortuneQuantityData> fortuneChanceEntry : dropData.fortunequantitymap.entrySet()) {
                player.func_145747_a(ChatUtil.getNormalMessage("Level " + fortuneChanceEntry.getKey() + "=" + fortuneChanceEntry.getValue().minquantity + ":" + fortuneChanceEntry.getValue().maxquantity));
            }
            player.func_145747_a(ChatUtil.getNormalMessage("----------------------"));
            return;
        }
        player.func_145747_a(ChatUtil.getNormalMessage("Y-Level=" + dropData.minYLevel + ":" + dropData.maxYLevel));
        player.func_145747_a(ChatUtil.getNormalMessage("Exp=" + dropData.minExp + ":" + dropData.maxExp));
        player.func_145747_a(ChatUtil.getNormalMessage("Tools Blacklist=" + dropData.toolsBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("Biomes Blacklist=" + dropData.biomeBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("Gamestages Blacklist=" + dropData.gamestageBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("Gamestages All=" + dropData.gamestageAll));
        player.func_145747_a(ChatUtil.getNormalMessage("Modifiers Blacklist=" + dropData.modifierBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("Traits Blacklist=" + dropData.traitBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("Enchants Blacklist=" + dropData.enchantmentBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("NBTs Blacklist=" + dropData.nbtBlacklist));
        player.func_145747_a(ChatUtil.getNormalMessage("Exclusive=" + dropData.exclusive));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabList = new ArrayList<String>();
        tabList.add("fortunechance");
        tabList.add("fortunequantity");
        return DropGetCommand.func_175762_a((String[])args, tabList);
    }
}

