/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropEnchantAddCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "add";
    }

    @Override
    protected String getCommandPath() {
        return "drop.enchant.add";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        BlockDropData blockDropData;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The block associated with the drop does not exist."));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        String enchant = args[0];
        if (Enchantment.func_180305_b((String)enchant) == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("That enchant does not exist."));
            return;
        }
        if (dropData.enchantmentList.contains(enchant)) {
            player.func_145747_a(ChatUtil.getNormalMessage("That enchant already exists."));
            return;
        }
        dropData.enchantmentList.add(enchant);
        player.func_145747_a(ChatUtil.getNormalMessage("Added Enchantment '" + enchant + "'"));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.length == 1) {
            tabList.addAll(DropEnchantAddCommand.func_175762_a((String[])args, (Collection)Enchantment.field_185264_b.func_148742_b()));
        }
        return tabList;
    }
}

