/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.core.asm;

import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import tyra314.toolprogression.core.AsmHooks;
import tyra314.toolprogression.core.ToolProgressionPlugin;

public class ToolProgressionClassTransformer
implements IClassTransformer {
    private static final String[] classesToTransform = new String[]{"net.minecraftforge.common.ForgeHooks"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        int index = Arrays.asList(classesToTransform).indexOf(transformedName);
        return index != -1 ? this.transform(index, basicClass) : basicClass;
    }

    private byte[] transform(int index, byte[] basicClass) {
        LogManager.getLogger((String)"toolprogression_core").info("Transforming: " + classesToTransform[index]);
        try {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(basicClass);
            reader.accept((ClassVisitor)node, 0);
            switch (index) {
                case 0: {
                    if (this.transformForgeHooks(node)) break;
                    LogManager.getLogger((String)"toolprogression_core").error("Something went wrong while applying the ToolProgression ASM. You'll better not continue. Sorry. Wanna yell at me? Look here: https://github.com/tyra314/ToolProgression/issues");
                }
            }
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return basicClass;
        }
    }

    private boolean transformForgeHooks(ClassNode forgeHooksClass) {
        String CAN_HARVEST = "canHarvestBlock";
        String CAN_HARVEST_DESC = ToolProgressionPlugin.isObf ? "(Laow;Laed;Lamy;Let;)Z" : "(Lnet/minecraft/block/Block;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z";
        for (MethodNode method : forgeHooksClass.methods) {
            if (!method.name.equals("canHarvestBlock") || !method.desc.equals(CAN_HARVEST_DESC)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 2 || !(instruction.getPrevious() instanceof LineNumberNode)) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode == null) continue;
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(AsmHooks.class), "canHarvestBlock", ToolProgressionPlugin.isObf ? "(Laed;Lamy;Let;)Z" : "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", false));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            method.instructions.insertBefore(targetNode, toInsert);
            return true;
        }
        return false;
    }
}

