/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.ic2;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.recipe.Recipes;
import info.tritusk.modpack.crafttweaker.support.ic2.CraftTweakerActions;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.ScrapBox")
@ZenRegister
public final class ScrapBoxSupport {
    @ZenMethod
    public static void addDrop(WeightedItemStack weightedItem) {
        CraftTweakerActions.apply(new AddScrapBoxDropAction(weightedItem));
    }

    @ZenMethod
    public static void addDrop(IItemStack item, float chance) {
        CraftTweakerActions.apply(new AddScrapBoxDropAction(item, chance));
    }

    private static final class AddScrapBoxDropAction
    implements IAction {
        private final float weight;
        private final ItemStack item;

        AddScrapBoxDropAction(WeightedItemStack weightedItem) {
            this(weightedItem.getStack(), weightedItem.getChance());
        }

        AddScrapBoxDropAction(IItemStack item, float weight) {
            this.item = CraftTweakerMC.getItemStack((IItemStack)item);
            this.weight = weight;
        }

        public void apply() {
            Recipes.scrapboxDrops.addDrop(this.item, this.weight);
        }

        public String describe() {
            return null;
        }
    }
}

