/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.ic2;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import info.tritusk.modpack.crafttweaker.support.ic2.CraftTweakerActions;
import info.tritusk.modpack.crafttweaker.support.ic2.IC2RecipeInputs;
import java.util.Locale;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.Recycler")
@ZenRegister
public final class RecyclerSupport {
    @ZenMethod
    public static void addBlacklist(IItemStack item) {
        CraftTweakerActions.apply(new RecyclingBlacklistAction(IC2RecipeInputs.of(item)));
    }

    @ZenMethod
    public static void addBlacklist(IIngredient ingredient) {
        CraftTweakerActions.apply(new RecyclingBlacklistAction(IC2RecipeInputs.of(ingredient)));
    }

    private static final class RecyclingBlacklistAction
    implements IAction {
        private final IRecipeInput in;

        RecyclingBlacklistAction(IRecipeInput in) {
            this.in = in;
        }

        public void apply() {
            Recipes.recyclerBlacklist.add(this.in);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Blacklist %s from recycling", this.in);
        }
    }
}

