/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.ic2;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.recipe.ILiquidHeatExchangerManager;
import ic2.api.recipe.Recipes;
import info.tritusk.modpack.crafttweaker.support.ic2.CraftTweakerActions;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.HeatExchanger")
@ZenRegister
public final class HeatExchangerSupport {
    @ZenMethod
    public static void addFluidCoolDown(ILiquidStack output, ILiquidStack input, int heat) {
        CraftTweakerActions.apply(new HeatExchangeAction(Recipes.liquidCooldownManager, CraftTweakerMC.getLiquidStack((ILiquidStack)input), CraftTweakerMC.getLiquidStack((ILiquidStack)output), heat));
    }

    @ZenMethod
    public static void addFluidCoolDown(ILiquidDefinition output, ILiquidDefinition input, int heat) {
        CraftTweakerActions.apply(new HeatExchangeAction(Recipes.liquidCooldownManager, CraftTweakerMC.getFluid((ILiquidDefinition)input), CraftTweakerMC.getFluid((ILiquidDefinition)output), heat));
    }

    @ZenMethod
    public static void addFluidHeatUp(ILiquidStack output, ILiquidStack input, int heat) {
        CraftTweakerActions.apply(new HeatExchangeAction(Recipes.liquidHeatupManager, CraftTweakerMC.getLiquidStack((ILiquidStack)input), CraftTweakerMC.getLiquidStack((ILiquidStack)output), heat));
    }

    @ZenMethod
    public static void addFluidHeatUp(ILiquidDefinition output, ILiquidDefinition input, int heat) {
        CraftTweakerActions.apply(new HeatExchangeAction(Recipes.liquidHeatupManager, CraftTweakerMC.getFluid((ILiquidDefinition)input), CraftTweakerMC.getFluid((ILiquidDefinition)output), heat));
    }

    private static final class HeatExchangeAction
    implements IAction {
        private final ILiquidHeatExchangerManager manager;
        private final Fluid input;
        private final Fluid output;
        private final int heat;

        HeatExchangeAction(ILiquidHeatExchangerManager manager, FluidStack input, FluidStack output, int heat) {
            this(manager, input.getFluid(), output.getFluid(), heat);
        }

        HeatExchangeAction(ILiquidHeatExchangerManager manager, Fluid input, Fluid output, int heat) {
            this.manager = manager;
            this.input = input;
            this.output = output;
            this.heat = heat;
        }

        public void apply() {
            this.manager.addFluid(this.input.getName(), this.output.getName(), this.heat);
        }

        public String describe() {
            return null;
        }
    }
}

