/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.items.ItemFormType;

public class JAOPCAItem
extends Item
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;
    protected final IItemFormSettings settings;
    protected OptionalInt itemStackLimit = OptionalInt.empty();
    protected Optional<Boolean> beaconPayment = Optional.empty();
    protected Optional<Boolean> hasEffect = Optional.empty();
    protected Optional<Rarity> field_208075_l = Optional.empty();
    protected OptionalInt burnTime = OptionalInt.empty();

    public JAOPCAItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(new Item.Properties().func_200916_a(material.getType().isDummy() ? null : ItemFormType.getItemGroup()));
        this.form = form;
        this.material = material;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.itemStackLimit.isPresent()) {
            this.itemStackLimit = OptionalInt.of(this.settings.getItemStackLimitFunction().applyAsInt(this.material));
        }
        return this.itemStackLimit.getAsInt();
    }

    public boolean isBeaconPayment(ItemStack stack) {
        if (!this.beaconPayment.isPresent()) {
            this.beaconPayment = Optional.of(this.settings.getIsBeaconPaymentFunction().test(this.material));
        }
        return this.beaconPayment.get();
    }

    public boolean func_77636_d(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.material));
        }
        return this.hasEffect.get();
    }

    public Rarity func_77613_e(ItemStack stack) {
        if (!this.field_208075_l.isPresent()) {
            this.field_208075_l = Optional.of(this.settings.getDisplayRarityFunction().apply((Object)this.material));
        }
        return this.field_208075_l.get();
    }

    public int getBurnTime(ItemStack itemStack) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.material));
        }
        return this.burnTime.getAsInt();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return JAOPCAApi.instance().currentLocalizer().localizeMaterialForm("item.jaopca." + this.form.getName(), this.material, this.func_77658_a());
    }
}

