/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import com.google.common.collect.TreeBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IFluidFormType;
import thelm.jaopca.api.fluids.IFluidInfo;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.custom.json.FluidFormSettingsDeserializer;
import thelm.jaopca.custom.json.ForgeRegistryEntrySupplierDeserializer;
import thelm.jaopca.data.DataInjector;
import thelm.jaopca.fluids.FluidFormSettings;
import thelm.jaopca.fluids.FluidInfo;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.utils.ApiImpl;

public class FluidFormType
implements IFluidFormType {
    public static final FluidFormType INSTANCE = new FluidFormType();
    private static final TreeSet<IForm> FORMS = new TreeSet();
    private static final TreeBasedTable<IForm, IMaterial, IMaterialFormFluid> FLUIDS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IMaterialFormFluidBlock> FLUID_BLOCKS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IMaterialFormBucketItem> BUCKET_ITEMS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IFluidInfo> FLUID_INFOS = TreeBasedTable.create();
    public static final Type SOUND_EVENT_SUPPLIER_TYPE = new TypeToken<Supplier<SoundEvent>>(){}.getType();

    private FluidFormType() {
    }

    public static void init() {
        FormTypeHandler.registerFormType(INSTANCE);
    }

    @Override
    public String getName() {
        return "fluid";
    }

    @Override
    public void addForm(IForm form) {
        FORMS.add(form);
    }

    @Override
    public Set<IForm> getForms() {
        return Collections.unmodifiableNavigableSet(FORMS);
    }

    @Override
    public boolean shouldRegister(IForm form, IMaterial material) {
        if (material.getType().isDummy()) {
            return true;
        }
        ResourceLocation tagLocation = new ResourceLocation("forge", form.getSecondaryName() + '/' + material.getName());
        return !ApiImpl.INSTANCE.getFluidTags().contains(tagLocation);
    }

    @Override
    public IFluidInfo getMaterialFormInfo(IForm form, IMaterial material) {
        IFluidInfo info = (IFluidInfo)FLUID_INFOS.get((Object)form, (Object)material);
        if (info == null && FORMS.contains(form) && form.getMaterials().contains(material)) {
            info = new FluidInfo((IMaterialFormFluid)FLUIDS.get((Object)form, (Object)material), (IMaterialFormFluidBlock)FLUID_BLOCKS.get((Object)form, (Object)material), (IMaterialFormBucketItem)BUCKET_ITEMS.get((Object)form, (Object)material));
            FLUID_INFOS.put((Object)form, (Object)material, (Object)info);
        }
        return info;
    }

    @Override
    public IFluidFormSettings getNewSettings() {
        return new FluidFormSettings();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder builder) {
        return builder.registerTypeAdapter(SOUND_EVENT_SUPPLIER_TYPE, (Object)ForgeRegistryEntrySupplierDeserializer.INSTANCE);
    }

    @Override
    public IFluidFormSettings deserializeSettings(JsonElement jsonElement, JsonDeserializationContext context) {
        return FluidFormSettingsDeserializer.INSTANCE.deserialize(jsonElement, context);
    }

    private static void createRegistryEntries() {
        for (IForm form : FORMS) {
            IFluidFormSettings settings = (IFluidFormSettings)form.getSettings();
            for (IMaterial material : form.getMaterials()) {
                boolean isMaterialDummy = material.getType().isDummy();
                String registryKey = isMaterialDummy ? material.getName() + form.getName() : form.getName() + '.' + material.getName();
                ResourceLocation registryName = new ResourceLocation("jaopca", registryKey);
                IMaterialFormFluid materialFormFluid = settings.getFluidCreator().create(form, material, settings);
                Fluid fluid = materialFormFluid.asFluid();
                fluid.setRegistryName(registryName);
                FLUIDS.put((Object)form, (Object)material, (Object)materialFormFluid);
                IMaterialFormFluidBlock materialFormFluidBlock = settings.getFluidBlockCreator().create(materialFormFluid, settings);
                Block fluidBlock = materialFormFluidBlock.asBlock();
                fluidBlock.setRegistryName(registryName);
                FLUID_BLOCKS.put((Object)form, (Object)material, (Object)materialFormFluidBlock);
                IMaterialFormBucketItem materialFormBucketItem = settings.getBucketItemCreator().create(materialFormFluid, settings);
                Item bucketItem = materialFormBucketItem.asItem();
                bucketItem.setRegistryName(registryName);
                BUCKET_ITEMS.put((Object)form, (Object)material, (Object)materialFormBucketItem);
                if (isMaterialDummy) continue;
                Supplier<Fluid> fluidSupplier = () -> fluid;
                DataInjector.registerFluidTag(new ResourceLocation("forge", form.getSecondaryName()), fluidSupplier);
                DataInjector.registerFluidTag(new ResourceLocation("forge", form.getSecondaryName() + '/' + material.getName()), fluidSupplier);
                for (String alternativeName : material.getAlternativeNames()) {
                    DataInjector.registerFluidTag(new ResourceLocation("forge", form.getSecondaryName() + '/' + alternativeName), fluidSupplier);
                }
            }
        }
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        FluidFormType.createRegistryEntries();
        for (IMaterialFormFluidBlock fluidBlock : FLUID_BLOCKS.values()) {
            registry.register((IForgeRegistryEntry)fluidBlock.asBlock());
        }
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (IMaterialFormBucketItem bucketItem : BUCKET_ITEMS.values()) {
            registry.register((IForgeRegistryEntry)bucketItem.asItem());
        }
    }

    public static void registerFluids(IForgeRegistry<Fluid> registry) {
        for (IMaterialFormFluid fluid : FLUIDS.values()) {
            registry.register((IForgeRegistryEntry)fluid.asFluid());
        }
    }

    public static Collection<IMaterialFormFluid> getFluids() {
        return FLUIDS.values();
    }

    public static Collection<IMaterialFormFluidBlock> getFluidBlocks() {
        return FLUID_BLOCKS.values();
    }

    public static Collection<IMaterialFormBucketItem> getBucketItems() {
        return BUCKET_ITEMS.values();
    }
}

