/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.BinomialRange;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IntClamper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryManager;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.resources.InMemoryResourcePack;

public class DataInjector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ListMultimap<ResourceLocation, Supplier<? extends Block>> BLOCK_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, Supplier<? extends Item>> ITEM_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, Supplier<? extends Fluid>> FLUID_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, Supplier<? extends EntityType<?>>> ENTITY_TYPE_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final TreeMap<ResourceLocation, Supplier<? extends IRecipe<?>>> RECIPES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<LootTable>> LOOT_TABLES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<Advancement.Builder>> ADVANCEMENTS_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<? extends JsonElement>> JSONS_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<String>> STRINGS_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<? extends InputStream>> INPUT_STREAMS_INJECT = new TreeMap();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(BinomialRange.class, (Object)new BinomialRange.Serializer()).registerTypeAdapter(ConstantRange.class, (Object)new ConstantRange.Serializer()).registerTypeAdapter(IntClamper.class, (Object)new IntClamper.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntryManager.Serializer()).registerTypeHierarchyAdapter(ILootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(ILootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final RecipeManager recipeManager;

    public static boolean registerBlockTag(ResourceLocation location, Supplier<? extends Block> blockSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(blockSupplier);
        return BLOCK_TAGS_INJECT.put((Object)location, blockSupplier);
    }

    public static boolean registerItemTag(ResourceLocation location, Supplier<? extends Item> itemSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(itemSupplier);
        return ITEM_TAGS_INJECT.put((Object)location, itemSupplier);
    }

    public static boolean registerFluidTag(ResourceLocation location, Supplier<? extends Fluid> fluidSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(fluidSupplier);
        return FLUID_TAGS_INJECT.put((Object)location, fluidSupplier);
    }

    public static boolean registerEntityTypeTag(ResourceLocation location, Supplier<? extends EntityType<?>> entityTypeSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(entityTypeSupplier);
        return ENTITY_TYPE_TAGS_INJECT.put((Object)location, entityTypeSupplier);
    }

    public static boolean registerRecipe(ResourceLocation location, Supplier<? extends IRecipe<?>> recipeSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(recipeSupplier);
        return RECIPES_INJECT.putIfAbsent(location, recipeSupplier) == null;
    }

    public static boolean registerLootTable(ResourceLocation location, Supplier<LootTable> lootTableSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(lootTableSupplier);
        return LOOT_TABLES_INJECT.putIfAbsent(location, lootTableSupplier) == null;
    }

    public static boolean registerAdvancement(ResourceLocation location, Supplier<Advancement.Builder> advancementBuilder) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(advancementBuilder);
        return ADVANCEMENTS_INJECT.putIfAbsent(location, advancementBuilder) == null;
    }

    public static boolean injectJson(ResourceLocation location, Supplier<? extends JsonElement> jsonSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(jsonSupplier);
        return JSONS_INJECT.putIfAbsent(location, jsonSupplier) == null;
    }

    public static boolean injectString(ResourceLocation location, Supplier<String> stringSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(stringSupplier);
        return STRINGS_INJECT.putIfAbsent(location, stringSupplier) == null;
    }

    public static boolean injectInputStream(ResourceLocation location, Supplier<? extends InputStream> streamSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(streamSupplier);
        return INPUT_STREAMS_INJECT.putIfAbsent(location, streamSupplier) == null;
    }

    public static Set<ResourceLocation> getInjectBlockTags() {
        return BLOCK_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectItemTags() {
        return ITEM_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectFluidTags() {
        return FLUID_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectEntityTypeTags() {
        return ENTITY_TYPE_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectRecipes() {
        return RECIPES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectLootTables() {
        return LOOT_TABLES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectAdvancements() {
        return ADVANCEMENTS_INJECT.navigableKeySet();
    }

    public static DataInjector getNewInstance(RecipeManager recipeManager) {
        return new DataInjector(recipeManager);
    }

    private DataInjector(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public void injectRecipes(IResourceManager resourceManager) {
        ArrayList<IRecipe> recipesToInject = new ArrayList<IRecipe>();
        for (Map.Entry<ResourceLocation, Supplier<IRecipe<?>>> entry2 : RECIPES_INJECT.entrySet()) {
            IRecipe recipe = null;
            try {
                recipe = entry2.getValue().get();
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Recipe with ID {} received invalid arguments: {}", (Object)entry2.getKey(), (Object)e.getMessage());
                continue;
            }
            if (recipe == null) {
                LOGGER.warn("Recipe with ID {} returned null", (Object)entry2.getKey());
                continue;
            }
            if (!recipe.func_199560_c().equals((Object)entry2.getKey())) {
                LOGGER.warn("Recipe ID {} and registry key {} do not match", (Object)recipe.func_199560_c(), (Object)entry2.getKey());
                continue;
            }
            if (this.recipeManager.func_215378_c().anyMatch(arg_0 -> ((ResourceLocation)entry2.getKey()).equals(arg_0))) {
                LOGGER.warn("Duplicate recipe ignored with ID {}", (Object)entry2.getKey());
                continue;
            }
            recipesToInject.add(recipe);
        }
        Map<IRecipeType, ImmutableMap.Builder> recipesCopy = this.recipeManager.field_199522_d.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ImmutableMap.builder().putAll((Map)entry.getValue())));
        for (IRecipe recipe : recipesToInject) {
            recipesCopy.computeIfAbsent(recipe.func_222127_g(), type -> ImmutableMap.builder()).put((Object)recipe.func_199560_c(), (Object)recipe);
        }
        this.recipeManager.field_199522_d = (Map)recipesCopy.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).build()));
        LOGGER.info("Injected {} recipes, {} recipes total", (Object)recipesToInject.size(), (Object)this.recipeManager.func_215378_c().count());
        ModuleHandler.onRecipeInjectComplete(resourceManager);
    }

    public static class PackFinder
    implements IPackFinder {
        public static final PackFinder INSTANCE = new PackFinder();

        public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packList, ResourcePackInfo.IFactory<T> factory) {
            ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)"inmemory:jaopca", (boolean)true, () -> {
                InMemoryResourcePack pack = new InMemoryResourcePack("inmemory:jaopca", true);
                BLOCK_TAGS_INJECT.asMap().forEach((location, suppliers) -> {
                    Object[] blocks = (Block[])suppliers.stream().map(Supplier::get).distinct().filter(Objects::nonNull).toArray(Block[]::new);
                    Tag tag = Tag.Builder.func_200047_a().func_200573_a(blocks).func_200051_a(location);
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/blocks/" + location.func_110623_a() + ".json"), (JsonElement)tag.func_200571_a(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)));
                });
                ITEM_TAGS_INJECT.asMap().forEach((location, suppliers) -> {
                    Object[] items = (Item[])suppliers.stream().map(Supplier::get).distinct().filter(Objects::nonNull).toArray(Item[]::new);
                    Tag tag = Tag.Builder.func_200047_a().func_200573_a(items).func_200051_a(location);
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/items/" + location.func_110623_a() + ".json"), (JsonElement)tag.func_200571_a(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)));
                });
                FLUID_TAGS_INJECT.asMap().forEach((location, suppliers) -> {
                    Object[] fluids = (Fluid[])suppliers.stream().map(Supplier::get).distinct().filter(Objects::nonNull).toArray(Fluid[]::new);
                    Tag tag = Tag.Builder.func_200047_a().func_200573_a(fluids).func_200051_a(location);
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/fluids/" + location.func_110623_a() + ".json"), (JsonElement)tag.func_200571_a(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0)));
                });
                ENTITY_TYPE_TAGS_INJECT.asMap().forEach((location, suppliers) -> {
                    Object[] entityTypes = (EntityType[])suppliers.stream().map(Supplier::get).distinct().filter(Objects::nonNull).toArray(EntityType[]::new);
                    Tag tag = Tag.Builder.func_200047_a().func_200573_a(entityTypes).func_200051_a(location);
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/entity_types/" + location.func_110623_a() + ".json"), (JsonElement)tag.func_200571_a(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getKey(arg_0)));
                });
                LOOT_TABLES_INJECT.forEach((location, supplier) -> pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "loot_tables/" + location.func_110623_a() + ".json"), GSON.toJsonTree(supplier.get())));
                ADVANCEMENTS_INJECT.forEach((location, supplier) -> pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "advancements/" + location.func_110623_a() + ".json"), (JsonElement)((Advancement.Builder)supplier.get()).func_200273_b()));
                JSONS_INJECT.forEach((location, supplier) -> pack.putJson(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (JsonElement)supplier.get()));
                STRINGS_INJECT.forEach((location, supplier) -> pack.putString(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (String)supplier.get()));
                INPUT_STREAMS_INJECT.forEach((location, supplier) -> pack.putInputStream(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (Supplier<? extends InputStream>)supplier));
                return pack;
            }, factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM);
            if (packInfo != null) {
                packList.put("inmemory:jaopca", packInfo);
            }
        }
    }
}

