/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.resources;

import com.google.gson.JsonElement;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.resources.InMemoryResourcePack;

public class ResourceInjector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TreeMap<ResourceLocation, Supplier<? extends JsonElement>> JSONS_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<String>> STRINGS_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<? extends InputStream>> INPUT_STREAMS_INJECT = new TreeMap();

    public static boolean injectJson(ResourceLocation location, Supplier<? extends JsonElement> jsonSupplier) {
        return JSONS_INJECT.putIfAbsent(location, jsonSupplier) == null;
    }

    public static boolean injectString(ResourceLocation location, Supplier<String> stringSupplier) {
        return STRINGS_INJECT.putIfAbsent(location, stringSupplier) == null;
    }

    public static boolean injectInputStream(ResourceLocation location, Supplier<? extends InputStream> streamSupplier) {
        return INPUT_STREAMS_INJECT.putIfAbsent(location, streamSupplier) == null;
    }

    public static class PackFinder
    implements IPackFinder {
        public static final PackFinder INSTANCE = new PackFinder();

        public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packList, ResourcePackInfo.IFactory<T> factory) {
            ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)"inmemory:jaopca", (boolean)true, () -> {
                InMemoryResourcePack pack = new InMemoryResourcePack("inmemory:jaopca", true);
                JSONS_INJECT.forEach((location, supplier) -> pack.putJson(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (JsonElement)supplier.get()));
                STRINGS_INJECT.forEach((location, supplier) -> pack.putString(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (String)supplier.get()));
                INPUT_STREAMS_INJECT.forEach((location, supplier) -> pack.putInputStream(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (Supplier<? extends InputStream>)supplier));
                return pack;
            }, factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM);
        }
    }
}

