/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Rarity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraftforge.common.ToolType;
import thelm.jaopca.api.blocks.IBlockCreator;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IBlockItemCreator;
import thelm.jaopca.api.blocks.IBlockLootTableCreator;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.blocks.JAOPCABlock;
import thelm.jaopca.blocks.JAOPCABlockItem;
import thelm.jaopca.utils.MiscHelper;

public class BlockFormSettings
implements IBlockFormSettings {
    private IBlockCreator blockCreator = JAOPCABlock::new;
    private Function<IMaterial, Material> materialFunction = material -> Material.field_151573_f;
    private Function<IMaterial, MaterialColor> materialColorFunction = material -> {
        int color = material.getColor();
        return Arrays.stream(MaterialColor.field_76281_a).filter(Objects::nonNull).min((matColor1, matColor2) -> Integer.compare(MiscHelper.INSTANCE.squareColorDifference(color, matColor1.field_76291_p), MiscHelper.INSTANCE.squareColorDifference(color, matColor2.field_76291_p))).orElse(MaterialColor.field_151668_h);
    };
    private boolean blocksMovement = true;
    private Function<IMaterial, SoundType> soundTypeFunction = material -> SoundType.field_185852_e;
    private ToIntFunction<IMaterial> lightValueFunction = material -> 0;
    private ToDoubleFunction<IMaterial> blockHardnessFunction = material -> 5.0;
    private ToDoubleFunction<IMaterial> explosionResistanceFunction = material -> 6.0;
    private ToDoubleFunction<IMaterial> slipperinessFunction = material -> 0.6;
    private boolean isFull = true;
    private VoxelShape shape = VoxelShapes.func_197868_b();
    private VoxelShape raytraceShape = VoxelShapes.func_197880_a();
    private BlockRenderLayer renderLayer = BlockRenderLayer.TRANSLUCENT;
    private Function<IMaterial, ToolType> harvestToolFunction = material -> ToolType.PICKAXE;
    private ToIntFunction<IMaterial> harvestLevelFunction = material -> 0;
    private Predicate<IMaterial> isBeaconBaseFunction = material -> false;
    private ToIntFunction<IMaterial> flammabilityFunction = material -> 0;
    private ToIntFunction<IMaterial> fireSpreadSpeedFunction = material -> 0;
    private Predicate<IMaterial> isFireSourceFunction = material -> false;
    private IBlockLootTableCreator blockLootTableCreator = (block, settings) -> LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block.asBlock())).func_212840_b_(SurvivesExplosion.func_215968_b())).func_216038_b();
    private IBlockItemCreator itemBlockCreator = JAOPCABlockItem::new;
    private ToIntFunction<IMaterial> itemStackLimitFunction = material -> 64;
    private Predicate<IMaterial> beaconPaymentFunction = material -> false;
    private Predicate<IMaterial> hasEffectFunction = material -> material.hasEffect();
    private Function<IMaterial, Rarity> displayRarityFunction = material -> material.getDisplayRarity();
    private ToIntFunction<IMaterial> burnTimeFunction = material -> -1;

    BlockFormSettings() {
    }

    @Override
    public IFormType getType() {
        return BlockFormType.INSTANCE;
    }

    @Override
    public IBlockFormSettings setBlockCreator(IBlockCreator blockCreator) {
        this.blockCreator = blockCreator;
        return this;
    }

    @Override
    public IBlockCreator getBlockCreator() {
        return this.blockCreator;
    }

    @Override
    public IBlockFormSettings setMaterialFunction(Function<IMaterial, Material> materialFunction) {
        this.materialFunction = materialFunction;
        return this;
    }

    @Override
    public Function<IMaterial, Material> getMaterialFunction() {
        return this.materialFunction;
    }

    @Override
    public IBlockFormSettings setMaterialColorFunction(Function<IMaterial, MaterialColor> materialColorFunction) {
        this.materialColorFunction = materialColorFunction;
        return this;
    }

    @Override
    public Function<IMaterial, MaterialColor> getMaterialColorFunction() {
        return this.materialColorFunction;
    }

    @Override
    public IBlockFormSettings setBlocksMovement(boolean blocksMovement) {
        this.blocksMovement = blocksMovement;
        return this;
    }

    @Override
    public boolean getBlocksMovement() {
        return this.blocksMovement;
    }

    @Override
    public IBlockFormSettings setSoundTypeFunction(Function<IMaterial, SoundType> soundTypeFunction) {
        this.soundTypeFunction = soundTypeFunction;
        return this;
    }

    @Override
    public Function<IMaterial, SoundType> getSoundTypeFunction() {
        return this.soundTypeFunction;
    }

    @Override
    public IBlockFormSettings setLightValueFunction(ToIntFunction<IMaterial> lightValueFunction) {
        this.lightValueFunction = lightValueFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getLightValueFunction() {
        return this.lightValueFunction;
    }

    @Override
    public IBlockFormSettings setBlockHardnessFunction(ToDoubleFunction<IMaterial> blockHardnessFunction) {
        this.blockHardnessFunction = blockHardnessFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getBlockHardnessFunction() {
        return this.blockHardnessFunction;
    }

    @Override
    public IBlockFormSettings setExplosionResistanceFunction(ToDoubleFunction<IMaterial> explosionResistanceFunction) {
        this.explosionResistanceFunction = explosionResistanceFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getExplosionResistanceFunction() {
        return this.explosionResistanceFunction;
    }

    @Override
    public IBlockFormSettings setSlipperinessFunction(ToDoubleFunction<IMaterial> slipperinessFunction) {
        this.slipperinessFunction = slipperinessFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getSlipperinessFunction() {
        return this.slipperinessFunction;
    }

    @Override
    public IBlockFormSettings setShape(VoxelShape shape) {
        this.shape = shape;
        return this;
    }

    @Override
    public VoxelShape getShape() {
        return this.shape;
    }

    @Override
    public IBlockFormSettings setRaytraceShape(VoxelShape raytraceShape) {
        this.raytraceShape = raytraceShape;
        return this;
    }

    @Override
    public VoxelShape getRaytraceShape() {
        return this.raytraceShape;
    }

    @Override
    public IBlockFormSettings setRenderLayer(BlockRenderLayer renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    @Override
    public BlockRenderLayer getRenderLayer() {
        return this.renderLayer;
    }

    @Override
    public IBlockFormSettings setHarvestToolFunction(Function<IMaterial, ToolType> harvestToolFunction) {
        this.harvestToolFunction = harvestToolFunction;
        return this;
    }

    @Override
    public Function<IMaterial, ToolType> getHarvestToolFunction() {
        return this.harvestToolFunction;
    }

    @Override
    public IBlockFormSettings setHarvestLevelFunction(ToIntFunction<IMaterial> harvestLevelFunction) {
        this.harvestLevelFunction = harvestLevelFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getHarvestLevelFunction() {
        return this.harvestLevelFunction;
    }

    @Override
    public IBlockFormSettings setIsBeaconBaseFunction(Predicate<IMaterial> isBeaconBaseFunction) {
        this.isBeaconBaseFunction = isBeaconBaseFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getIsBeaconBaseFunction() {
        return this.isBeaconBaseFunction;
    }

    @Override
    public IBlockFormSettings setFlammabilityFunction(ToIntFunction<IMaterial> flammabilityFunction) {
        this.flammabilityFunction = flammabilityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFlammabilityFunction() {
        return this.flammabilityFunction;
    }

    @Override
    public IBlockFormSettings setFireSpreadSpeedFunction(ToIntFunction<IMaterial> fireSpreadSpeedFunction) {
        this.fireSpreadSpeedFunction = fireSpreadSpeedFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFireSpreadSpeedFunction() {
        return this.fireSpreadSpeedFunction;
    }

    @Override
    public IBlockFormSettings setIsFireSourceFunction(Predicate<IMaterial> isFireSourceFunction) {
        this.isFireSourceFunction = isFireSourceFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getIsFireSourceFunction() {
        return this.isFireSourceFunction;
    }

    @Override
    public IBlockFormSettings setBlockLootTableCreator(IBlockLootTableCreator blockLootTableCreator) {
        this.blockLootTableCreator = blockLootTableCreator;
        return this;
    }

    @Override
    public IBlockLootTableCreator getBlockLootTableCreator() {
        return this.blockLootTableCreator;
    }

    @Override
    public IBlockFormSettings setItemBlockCreator(IBlockItemCreator itemBlockCreator) {
        this.itemBlockCreator = itemBlockCreator;
        return this;
    }

    @Override
    public IBlockItemCreator getBlockItemCreator() {
        return this.itemBlockCreator;
    }

    @Override
    public IBlockFormSettings setItemStackLimitFunction(ToIntFunction<IMaterial> itemStackLimitFunction) {
        this.itemStackLimitFunction = itemStackLimitFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getItemStackLimitFunction() {
        return this.itemStackLimitFunction;
    }

    @Override
    public IBlockFormSettings setIsBeaconPaymentFunction(Predicate<IMaterial> beaconPaymentFunction) {
        this.beaconPaymentFunction = beaconPaymentFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getIsBeaconPaymentFunction() {
        return this.beaconPaymentFunction;
    }

    @Override
    public IBlockFormSettings setHasEffectFunction(Predicate<IMaterial> hasEffectFunction) {
        this.hasEffectFunction = hasEffectFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getHasEffectFunction() {
        return this.hasEffectFunction;
    }

    @Override
    public IBlockFormSettings setDisplayRarityFunction(Function<IMaterial, Rarity> displayRarityFunction) {
        this.displayRarityFunction = displayRarityFunction;
        return this;
    }

    @Override
    public Function<IMaterial, Rarity> getDisplayRarityFunction() {
        return this.displayRarityFunction;
    }

    @Override
    public IBlockFormSettings setBurnTimeFunction(ToIntFunction<IMaterial> burnTimeFunction) {
        this.burnTimeFunction = burnTimeFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getBurnTimeFunction() {
        return this.burnTimeFunction;
    }
}

