/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui.button;

import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.gui.GuiPortals;
import com.buuz135.portality.network.PortalLinkMessage;
import com.buuz135.portality.tile.TileController;
import com.hrznstudio.titanium.client.gui.addon.BasicGuiAddon;
import com.hrznstudio.titanium.client.gui.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;

public class PortalCallButton
extends BasicGuiAddon
implements IClickable {
    private final CallAction action;
    private final TileController controller;
    private final GuiPortals guiPortals;
    private int guiX;
    private int guiY;

    public PortalCallButton(int x, int y, TileController tile, CallAction action, GuiPortals guiPortals) {
        super(x, y);
        this.action = action;
        this.controller = tile;
        this.guiPortals = guiPortals;
        this.guiX = 0;
        this.guiY = 0;
    }

    public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/portals.png"));
        screen.blit(this.getPosX(), this.getPosY(), 0, 187, this.getXSize(), this.getYSize());
        this.guiX = guiX;
        this.guiY = guiY;
    }

    public boolean isInside(Screen container, double mouseX, double mouseY) {
        return super.isInside(container, mouseX + (double)this.guiX, mouseY + (double)this.guiY);
    }

    public int getXSize() {
        return 51;
    }

    public int getYSize() {
        return 22;
    }

    public void drawGuiContainerForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        screen.drawCenteredString(Minecraft.func_71410_x().field_71466_p, new TranslationTextComponent(this.action.getName(), new Object[0]).func_150261_e(), this.getPosX() + 25, this.getPosY() + 7, this.isInside(screen, mouseX - guiX, mouseY - guiY) ? 0xFFFFA0 : -1);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void handleClick(Screen tile, int guiX, int guiY, double mouseX, double mouseY, int button) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_180425_c()));
        if (this.guiPortals.getSelectedPortal() != null) {
            NetworkHandler.NETWORK.sendToServer((Object)new PortalLinkMessage(this.action.getId(), new PortalLinkData(this.controller.func_145831_w().func_201675_m().func_186058_p().func_186068_a(), this.controller.func_174877_v(), true), new PortalLinkData(this.guiPortals.getSelectedPortal().getDimension(), this.guiPortals.getSelectedPortal().getLocation(), false)));
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public static enum CallAction {
        OPEN(0, "portality.display.dial"),
        ONCE(1, "portality.display.dial_once"),
        FORCE(2, "portality.display.force");

        private int id;
        private String name;

        private CallAction(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

