/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.blocks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;

public class BlockStateWrapper
implements Comparable<BlockStateWrapper> {
    private final BlockState state;
    private final ImmutableSortedSet<IProperty<?>> propertiesByName;

    public BlockStateWrapper(BlockState state) {
        Preconditions.checkArgument((state.func_177230_c().getRegistryName() != null ? 1 : 0) != 0, (Object)"Attempted to construct wrapper for unregistered Block!");
        this.state = state;
        this.propertiesByName = ImmutableSortedSet.copyOf(Comparator.comparing(IProperty::func_177701_a), (Collection)state.func_206869_a());
    }

    public BlockState getState() {
        return this.state;
    }

    public ImmutableSortedSet<IProperty<?>> getProperties() {
        return this.propertiesByName;
    }

    @Override
    public int compareTo(@Nonnull BlockStateWrapper o) {
        assert (this.getState().func_177230_c().getRegistryName() != null);
        assert (o.getState().func_177230_c().getRegistryName() != null);
        int compare = this.getState().func_177230_c().getRegistryName().compareTo(o.getState().func_177230_c().getRegistryName());
        ImmutableList ownProps = this.getProperties().asList();
        ImmutableList otherProps = o.getProperties().asList();
        for (int i = 0; compare == 0 && i < ownProps.size() && i < otherProps.size(); ++i) {
            try {
                compare = this.getState().func_177229_b((IProperty)ownProps.get(i)).compareTo(o.getState().func_177229_b((IProperty)otherProps.get(i)));
                continue;
            }
            catch (Exception e) {
                compare = ((IProperty)ownProps.get(i)).func_177701_a().compareTo(((IProperty)otherProps.get(i)).func_177701_a());
            }
        }
        if (compare == 0) {
            compare = ownProps.size() - otherProps.size();
        }
        return compare;
    }

    public int hashCode() {
        assert (this.getState().func_177230_c().getRegistryName() != null);
        int hash = this.getState().func_177230_c().getRegistryName().hashCode();
        for (IProperty property : this.getProperties()) {
            hash = hash * 31 + this.getState().func_177229_b(property).hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockStateWrapper)) {
            return false;
        }
        BlockStateWrapper that = (BlockStateWrapper)o;
        ImmutableList ownProps = this.getProperties().asList();
        ImmutableList otherProps = that.getProperties().asList();
        for (int i = 0; i < ownProps.size() && i < otherProps.size(); ++i) {
            try {
                if (!this.getState().func_177229_b((IProperty)ownProps.get(i)).equals(that.getState().func_177229_b((IProperty)otherProps.get(i)))) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

