/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.blocks.TemplateManagerCommands;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.tiles.TemplateManagerTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTemplateManagerSave {
    private final BlockPos pos;
    private final String name;

    public PacketTemplateManagerSave(BlockPos blockPos, String TemplateName) {
        this.pos = blockPos;
        this.name = TemplateName;
    }

    public static void encode(PacketTemplateManagerSave msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.pos);
        buffer.func_180714_a(msg.name);
    }

    public static PacketTemplateManagerSave decode(PacketBuffer buffer) {
        return new PacketTemplateManagerSave(buffer.func_179259_c(), buffer.func_150789_c(125));
    }

    public static class Handler {
        public static void handle(PacketTemplateManagerSave msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                World world = player.field_70170_p;
                BlockPos pos = msg.pos;
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof TemplateManagerTileEntity)) {
                    return;
                }
                TemplateManagerContainer container = ((TemplateManagerTileEntity)te).getContainer((PlayerEntity)player);
                TemplateManagerCommands.saveTemplate(container, (PlayerEntity)player, msg.name);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

