/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockMap;
import com.direwolf20.buildinggadgets.common.util.buffers.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.common.util.buffers.ToolBufferBuilder;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL14;

public class CopyPasteRender
extends BaseRenderer {
    private ChestRenderer chestRenderer;

    public ChestRenderer getChestRenderer() {
        if (this.chestRenderer == null) {
            this.chestRenderer = new ChestRenderer();
        }
        return this.chestRenderer;
    }

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        if (BGItems.gadgetCopyPaste.getStartPos(heldItem) == null || BGItems.gadgetCopyPaste.getEndPos(heldItem) == null) {
            return;
        }
        Vec3d playerPos = CopyPasteRender.getPlayerPos();
        String UUID2 = BGItems.gadgetCopyPaste.getUUID(heldItem);
        if (GadgetCopyPaste.getToolMode(heldItem) == GadgetCopyPaste.ToolMode.Copy) {
            this.renderCopy(evt, player, heldItem, playerPos, UUID2);
        } else {
            this.renderPaste(evt, player, heldItem, playerPos, UUID2);
        }
    }

    private void renderCopy(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem, Vec3d playerPos, String UUID2) {
        BlockPos startPos = BGItems.gadgetCopyPaste.getStartPos(heldItem);
        BlockPos endPos = BGItems.gadgetCopyPaste.getEndPos(heldItem);
        BlockPos blankPos = new BlockPos(0, 0, 0);
        if (startPos == null || endPos == null || startPos.equals((Object)blankPos) || endPos.equals((Object)blankPos)) {
            return;
        }
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID2));
        if (blockMapList.size() == 0) {
            // empty if block
        }
        int x = startPos.func_177958_n() <= endPos.func_177958_n() ? startPos.func_177958_n() : endPos.func_177958_n();
        int y = startPos.func_177956_o() <= endPos.func_177956_o() ? startPos.func_177956_o() : endPos.func_177956_o();
        int z = startPos.func_177952_p() <= endPos.func_177952_p() ? startPos.func_177952_p() : endPos.func_177952_p();
        int dx = startPos.func_177958_n() > endPos.func_177958_n() ? startPos.func_177958_n() + 1 : endPos.func_177958_n() + 1;
        int dy = startPos.func_177956_o() > endPos.func_177956_o() ? startPos.func_177956_o() + 1 : endPos.func_177956_o() + 1;
        int dz = startPos.func_177952_p() > endPos.func_177952_p() ? startPos.func_177952_p() + 1 : endPos.func_177952_p() + 1;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        GlStateManager.disableLighting();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        CopyPasteRender.renderBox(tessellator, bufferbuilder, x, y, z, dx, dy, dz, 255, 223, 127);
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.enableDepthTest();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    private void renderPaste(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem, Vec3d playerPos, String UUID2) {
        World world = player.field_70170_p;
        BlockPos startPos = GadgetCopyPaste.getAnchor(heldItem);
        if (startPos == null) {
            startPos = VectorHelper.getPosLookingAt(player, heldItem);
            if (world.func_180495_p(startPos) == AIR) {
                return;
            }
            startPos = startPos.func_177981_b(GadgetCopyPaste.getY(heldItem));
            startPos = startPos.func_177965_g(GadgetCopyPaste.getX(heldItem));
            startPos = startPos.func_177970_e(GadgetCopyPaste.getZ(heldItem));
        } else {
            startPos = startPos.func_177981_b(GadgetCopyPaste.getY(heldItem));
            startPos = startPos.func_177965_g(GadgetCopyPaste.getX(heldItem));
            startPos = startPos.func_177970_e(GadgetCopyPaste.getZ(heldItem));
        }
        ToolBufferBuilder toolBufferBuilder = PasteToolBufferBuilder.getBufferFromMap(UUID2);
        if (toolBufferBuilder == null) {
            return;
        }
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID2));
        if (toolBufferBuilder.func_178989_h() == 0 || blockMapList.size() == 0) {
            return;
        }
        BlockState startBlock = world.func_180495_p(startPos);
        if (startBlock == BGBlocks.effectBlock.func_176223_P()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)32771, (int)32772);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        GlStateManager.translatef((float)startPos.func_177958_n(), (float)startPos.func_177956_o(), (float)startPos.func_177952_p());
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
        GlStateManager.translatef((float)5.0E-4f, (float)5.0E-4f, (float)-5.0E-4f);
        GlStateManager.scalef((float)0.999f, (float)0.999f, (float)0.999f);
        PasteToolBufferBuilder.draw(player, playerPos.func_82615_a(), playerPos.func_82617_b(), playerPos.func_82616_c(), startPos, UUID2);
        GlStateManager.popMatrix();
        for (BlockMap blockMap : blockMapList) {
            BlockState state = blockMap.state.getState();
            if (!state.hasTileEntity()) continue;
            TileEntity te = CopyPasteRender.getTileEntityWorld().getTE(state, world);
            TileEntityRenderer<TileEntity> teRender = CopyPasteRender.getTileEntityWorld().getTER(state, world);
            if (teRender == null) continue;
            GlStateManager.pushMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
            GlStateManager.translatef((float)startPos.func_177958_n(), (float)startPos.func_177956_o(), (float)startPos.func_177952_p());
            GlStateManager.translatef((float)blockMap.xOffset, (float)blockMap.yOffset, (float)blockMap.zOffset);
            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)32771, (int)32772);
            ItemStack renderStack = new ItemStack((IItemProvider)state.func_177230_c());
            if (renderStack.func_77973_b().getTileEntityItemStackRenderer() != ItemStackTileEntityRenderer.field_147719_a || CopyPasteRender.isVanillaISTER(renderStack)) {
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.getChestRenderer().func_178175_a(state.func_177230_c(), 1.0f);
            } else if (!CopyPasteRender.getInvalidTileEntities().contains(te)) {
                try {
                    TileEntityRendererDispatcher.field_147556_a.func_203602_a(te, 0.0, 0.0, 0.0, evt.getPartialTicks(), -1, true);
                }
                catch (Exception e) {
                    System.out.println("TER Exception with block type: " + state);
                    CopyPasteRender.getInvalidTileEntities().add(te);
                    GlStateManager.disableFog();
                    GlStateManager.popMatrix();
                }
            }
            GlStateManager.disableFog();
            GlStateManager.popMatrix();
        }
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    private static boolean isVanillaISTER(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BedBlock) {
            return true;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock) {
            return true;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() == Blocks.field_205165_jY) {
            return true;
        }
        if (item == Blocks.field_150477_bB.func_199767_j()) {
            return true;
        }
        if (item == Blocks.field_150447_bR.func_199767_j()) {
            return true;
        }
        if (Block.func_149634_a((Item)item) instanceof ShulkerBoxBlock) {
            return true;
        }
        return Block.func_149634_a((Item)item) instanceof ChestBlock;
    }

    private static void renderBox(Tessellator tessellator, BufferBuilder bufferBuilder, double startX, double startY, double startZ, double endX, double endY, double endZ, int R, int G, int B) {
        GlStateManager.lineWidth((float)2.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, B, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(B, B, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(B, G, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.lineWidth((float)1.0f);
    }
}

