/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.util;

import net.minecraft.util.math.BlockPos;

public final class MathUtils {
    public static final int B1_BYTE_MASK = 255;
    public static final int B2_BYTE_MASK = 65535;
    public static final int B3_BYTE_MASK = 0xFFFFFF;
    public static final long B5_BYTE_MASK = -1L;

    private MathUtils() {
    }

    public static short additiveInverse(short num) {
        return -num;
    }

    public static long posToLong(BlockPos pos) {
        long res = (long)(pos.func_177958_n() & 0xFFFF) << 24;
        res |= (long)((pos.func_177956_o() & 0xFF) << 16);
        return res |= (long)(pos.func_177952_p() & 0xFFFF);
    }

    public static BlockPos posFromLong(long serialized) {
        int x = (int)(serialized >> 24 & 0xFFFFL);
        int y = (int)(serialized >> 16 & 0xFFL);
        int z = (int)(serialized & 0xFFFFL);
        return new BlockPos(x, y, z);
    }

    public static long includeStateId(long serialized, int id) {
        return serialized | (long)(id & 0xFFFFFF) << 40;
    }

    public static int readStateId(long serialized) {
        return (int)(serialized >> 40 & 0xFFFFFFL);
    }

    public static long readSerializedPos(long serialized) {
        return serialized & 0xFFFFFFFFFFFFFFFFL;
    }

    public static int floorMultiple(int i, int factor) {
        return i - i % factor;
    }

    public static int ceilMultiple(int i, int factor) {
        return i + i % factor;
    }

    public static boolean isEven(int i) {
        return (i & 1) == 0;
    }

    public static boolean isOdd(int i) {
        return i % 2 == 1;
    }

    private static int addForNonEven(int i, int c) {
        return MathUtils.isEven(i) ? i : i + c;
    }

    private static int addForNonOdd(int i, int c) {
        return MathUtils.isOdd(i) ? i : i + c;
    }

    public static int floorToEven(int i) {
        return MathUtils.addForNonEven(i, -1);
    }

    public static int floorToOdd(int i) {
        return MathUtils.addForNonOdd(i, -1);
    }

    public static int ceilToEven(int i) {
        return MathUtils.addForNonEven(i, 1);
    }

    public static int ceilToOdd(int i) {
        return MathUtils.addForNonOdd(i, 1);
    }
}

