/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.modules.teleporter.blocks.SimpleDialerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SimpleDialerBlock
extends LogicSlabBlock {
    public SimpleDialerBlock() {
        super("simple_dialer", new BlockBuilder().tileEntitySupplier(SimpleDialerTileEntity::new));
    }

    public void func_190948_a(ItemStack itemStack, IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(itemStack, world, list, flag);
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("transX")) {
                int transX = tagCompound.func_74762_e("transX");
                int transY = tagCompound.func_74762_e("transY");
                int transZ = tagCompound.func_74762_e("transZ");
                int dim = tagCompound.func_74762_e("transDim");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Transmitter at: " + transX + "," + transY + "," + transZ + " (dim " + dim + ")"));
            }
            if (tagCompound.func_74764_b("receiver")) {
                int receiver = tagCompound.func_74762_e("receiver");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Receiver: " + receiver));
            }
            if (tagCompound.func_74767_n("once")) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Dial Once mode enabled"));
            }
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "When this block gets a redstone signal it"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "dials or interrupts a transmitter."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        if (!world.field_72995_K) {
            SimpleDialerTileEntity simpleDialerTileEntity = (SimpleDialerTileEntity)world.func_175625_s(pos);
            boolean onceMode = !simpleDialerTileEntity.isOnceMode();
            simpleDialerTileEntity.setOnceMode(onceMode);
            if (onceMode) {
                Logging.message((PlayerEntity)player, (String)"Enabled 'dial once' mode");
            } else {
                Logging.message((PlayerEntity)player, (String)"Disabled 'dial once' mode");
            }
        }
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, p_220069_6_);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SimpleDialerTileEntity) {
            SimpleDialerTileEntity simpleDialerTileEntity = (SimpleDialerTileEntity)te;
            simpleDialerTileEntity.update();
        }
    }
}

