/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.compat.jei;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendRecipe {
    private ItemStackList stacks;
    private BlockPos pos;

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            if (!stack.func_190926_b()) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                continue;
            }
            buf.writeBoolean(false);
        }
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketSendRecipe() {
    }

    public PacketSendRecipe(PacketBuffer buf) {
        int l = buf.readInt();
        this.stacks = ItemStackList.create((int)l);
        for (int i = 0; i < l; ++i) {
            if (buf.readBoolean()) {
                this.stacks.set(i, (Object)NetworkTools.readItemStack((ByteBuf)buf));
                continue;
            }
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.pos = buf.readBoolean() ? NetworkTools.readPos((ByteBuf)buf) : null;
    }

    public PacketSendRecipe(ItemStackList stacks, BlockPos pos) {
        this.stacks = stacks;
        this.pos = pos;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            World world = player.func_130014_f_();
            if (this.pos == null) {
                ItemStack itemStack = player.func_184614_ca();
            } else {
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof JEIRecipeAcceptor) {
                    JEIRecipeAcceptor acceptor = (JEIRecipeAcceptor)te;
                    acceptor.setGridContents((List)this.stacks);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

