/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockOffset {
    private int x;
    private int y;
    private int z;

    public BlockOffset(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockOffset() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public BlockOffset(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public BlockPos getPosition(BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.x, centerPos.func_177956_o() + this.y, centerPos.func_177952_p() + this.z);
    }

    public BlockPos getRotatedPosition(Direction dir, BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.getX(dir), centerPos.func_177956_o() + this.getY(dir), centerPos.func_177952_p() + this.getZ(dir));
    }

    private int getX(Direction dir) {
        switch (dir) {
            case EAST: {
                return -this.z;
            }
            case SOUTH: {
                return -this.x;
            }
            case WEST: {
                return this.z;
            }
        }
        return this.x;
    }

    private int getY(Direction dir) {
        return this.y;
    }

    private int getZ(Direction dir) {
        switch (dir) {
            case EAST: {
                return this.x;
            }
            case SOUTH: {
                return -this.z;
            }
            case WEST: {
                return -this.x;
            }
        }
        return this.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockOffset) {
            return this.same((BlockOffset)obj);
        }
        return false;
    }

    private BlockOffset getOffset(Direction dir) {
        return new BlockOffset(this.getX(dir), this.y, this.getZ(dir));
    }

    public boolean same(BlockOffset oth) {
        return this.x == oth.getXOffset() && this.y == oth.getYOffset() && this.z == oth.getZOffset();
    }

    public int getXOffset() {
        return this.x;
    }

    public int getYOffset() {
        return this.y;
    }

    public int getZOffset() {
        return this.z;
    }

    public String toString() {
        String str = "(";
        str = str + this.x + "," + this.y + "," + this.z + ")";
        return str;
    }

    public static BlockOffset getOffset(BlockPos pos, BlockPos offset) {
        return new BlockOffset(pos.func_177973_b((Vec3i)offset));
    }

    public static BlockOffset minEachValue(BlockOffset one, BlockOffset two) {
        return new BlockOffset(Math.min(one.getXOffset(), two.getXOffset()), Math.min(one.getYOffset(), two.getYOffset()), Math.min(one.getZOffset(), two.getZOffset()));
    }

    public static BlockOffset maxEachValue(BlockOffset one, BlockOffset two) {
        return new BlockOffset(Math.max(one.getXOffset(), two.getXOffset()), Math.max(one.getYOffset(), two.getYOffset()), Math.max(one.getZOffset(), two.getZOffset()));
    }
}

