/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeDefault;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeIDRegistry;
import java.util.Map;

public class ThemeRegistry {
    public static ThemeID DEFAULT = new ThemeID("default", "default");
    protected ThemeIDRegistry idRegistry;
    protected ThemeDefault themeDefault;
    protected Map<ThemeID, Theme> themeMap = Maps.newHashMap();
    protected static ThemeRegistry REGISTRY;

    public ThemeRegistry(ThemeIDRegistry idRegistry) {
        this.idRegistry = idRegistry;
        this.themeDefault = new ThemeDefault();
    }

    public void registerClientTheme(ThemeID id, Theme theme) {
        if (this.idRegistry.themeIDExists(id)) {
            this.themeMap.put(id, theme);
        }
    }

    public Theme getTheme(ThemeID id) {
        if (id == null || id == DEFAULT) {
            return this.themeDefault;
        }
        if (this.themeMap.containsKey(id)) {
            return this.themeMap.get(id);
        }
        return this.themeDefault;
    }

    public ThemeID getDefault() {
        return DEFAULT;
    }

    public static ThemeRegistry getInstance() {
        if (REGISTRY == null) {
            REGISTRY = new ThemeRegistry(ThemeIDRegistry.getInstance());
        }
        return REGISTRY;
    }
}

