/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.blocks.BaseBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class OrientationTools {
    public static final int MASK_ORIENTATION = 7;
    public static final int MASK_REDSTONE = 8;
    public static final int MASK_ORIENTATION_HORIZONTAL = 3;
    public static final int MASK_REDSTONE_IN = 8;
    public static final int MASK_REDSTONE_OUT = 4;
    public static final int MASK_STATE = 12;
    public static Direction[] DIRECTION_VALUES = Direction.values();
    public static Direction[] HORIZONTAL_DIRECTION_VALUES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static int setOrientation(int metadata, Direction orientation) {
        return metadata & 0xFFFFFFF8 | orientation.ordinal();
    }

    public static Direction getOrientationHoriz(BlockState state) {
        return (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
    }

    public static int setOrientationHoriz(int metadata, Direction orientation) {
        return metadata & 0xFFFFFFFC | OrientationTools.getHorizOrientationMeta(orientation);
    }

    public static int getHorizOrientationMeta(Direction orientation) {
        return orientation.ordinal() - 2;
    }

    public static Direction getOrientation(BlockState state) {
        return ((BaseBlock)state.func_177230_c()).getFrontDirection(state);
    }

    public static Direction determineOrientation(BlockPos pos, LivingEntity entity) {
        return OrientationTools.determineOrientation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entity);
    }

    public static Direction determineOrientation(int x, int y, int z, LivingEntity entity) {
        int i;
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return Direction.UP;
            }
            if ((double)y - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return (l = ((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5 < (double)(i = (int)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) ? i - 1 : i) & 3) == 0 ? Direction.NORTH : (l == 1 ? Direction.EAST : (l == 2 ? Direction.SOUTH : (l == 3 ? Direction.WEST : Direction.DOWN)));
    }

    public static Direction determineOrientationHoriz(LivingEntity MobEntity) {
        int i = (int)((double)(MobEntity.field_70177_z * 4.0f / 360.0f) + 0.5);
        int l = ((double)(MobEntity.field_70177_z * 4.0f / 360.0f) + 0.5 < (double)i ? i - 1 : i) & 3;
        return l == 0 ? Direction.NORTH : (l == 1 ? Direction.EAST : (l == 2 ? Direction.SOUTH : (l == 3 ? Direction.WEST : Direction.DOWN)));
    }

    public static Direction worldToBlockSpaceHoriz(Direction side, BlockState state) {
        return OrientationTools.worldToBlockSpace(side, OrientationTools.getOrientationHoriz(state));
    }

    public static Direction worldToBlockSpace(Direction worldSide, Direction blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (worldSide) {
                    case DOWN: {
                        return Direction.SOUTH;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.WEST;
                    }
                }
                return worldSide;
            }
            case UP: {
                switch (worldSide) {
                    case DOWN: {
                        return Direction.NORTH;
                    }
                    case UP: {
                        return Direction.SOUTH;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.EAST;
                    }
                }
                return worldSide;
            }
            case NORTH: {
                if (worldSide == Direction.DOWN || worldSide == Direction.UP) {
                    return worldSide;
                }
                return worldSide.func_176734_d();
            }
            case SOUTH: {
                return worldSide;
            }
            case WEST: {
                if (worldSide == Direction.DOWN || worldSide == Direction.UP) {
                    return worldSide;
                }
                if (worldSide == Direction.WEST) {
                    return Direction.SOUTH;
                }
                if (worldSide == Direction.NORTH) {
                    return Direction.WEST;
                }
                if (worldSide == Direction.EAST) {
                    return Direction.NORTH;
                }
                return Direction.EAST;
            }
            case EAST: {
                if (worldSide == Direction.DOWN || worldSide == Direction.UP) {
                    return worldSide;
                }
                if (worldSide == Direction.WEST) {
                    return Direction.NORTH;
                }
                if (worldSide == Direction.NORTH) {
                    return Direction.EAST;
                }
                if (worldSide == Direction.EAST) {
                    return Direction.SOUTH;
                }
                return Direction.WEST;
            }
        }
        return worldSide;
    }

    public static Direction blockToWorldSpace(Direction blockSide, Direction blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (blockSide) {
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case DOWN: {
                        return Direction.SOUTH;
                    }
                    case EAST: {
                        return Direction.WEST;
                    }
                    case WEST: {
                        return Direction.EAST;
                    }
                }
                return blockSide;
            }
            case UP: {
                switch (blockSide) {
                    case NORTH: {
                        return Direction.DOWN;
                    }
                    case SOUTH: {
                        return Direction.UP;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case DOWN: {
                        return Direction.SOUTH;
                    }
                    case WEST: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.EAST;
                    }
                }
                return blockSide;
            }
            case NORTH: {
                if (blockSide == Direction.DOWN || blockSide == Direction.UP) {
                    return blockSide;
                }
                return blockSide.func_176734_d();
            }
            case SOUTH: {
                return blockSide;
            }
            case WEST: {
                if (blockSide == Direction.DOWN || blockSide == Direction.UP) {
                    return blockSide;
                }
                if (blockSide == Direction.SOUTH) {
                    return Direction.WEST;
                }
                if (blockSide == Direction.WEST) {
                    return Direction.NORTH;
                }
                if (blockSide == Direction.NORTH) {
                    return Direction.EAST;
                }
                return Direction.SOUTH;
            }
            case EAST: {
                if (blockSide == Direction.DOWN || blockSide == Direction.UP) {
                    return blockSide;
                }
                if (blockSide == Direction.NORTH) {
                    return Direction.WEST;
                }
                if (blockSide == Direction.EAST) {
                    return Direction.NORTH;
                }
                if (blockSide == Direction.SOUTH) {
                    return Direction.EAST;
                }
                return Direction.SOUTH;
            }
        }
        return blockSide;
    }

    public static Vec3d blockToWorldSpace(Vec3d v, BlockState state) {
        return OrientationTools.blockToWorldSpace(v, OrientationTools.getOrientation(state));
    }

    public static Vec3d worldToBlockSpace(Vec3d v, BlockState state) {
        return OrientationTools.worldToBlockSpace(v, OrientationTools.getOrientation(state));
    }

    public static Vec3d blockToWorldSpaceHoriz(Vec3d v, BlockState state) {
        return OrientationTools.blockToWorldSpace(v, OrientationTools.getOrientationHoriz(state));
    }

    public static Vec3d worldToBlockSpaceHoriz(Vec3d v, BlockState state) {
        return OrientationTools.worldToBlockSpace(v, OrientationTools.getOrientationHoriz(state));
    }

    public static Vec3d blockToWorldSpace(Vec3d v, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case UP: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case NORTH: {
                return new Vec3d(1.0 - v.field_72450_a, v.field_72448_b, 1.0 - v.field_72449_c);
            }
            case SOUTH: {
                return v;
            }
            case WEST: {
                return new Vec3d(1.0 - v.field_72449_c, v.field_72448_b, v.field_72450_a);
            }
            case EAST: {
                return new Vec3d(v.field_72449_c, v.field_72448_b, 1.0 - v.field_72450_a);
            }
        }
        return v;
    }

    public static Vec3d worldToBlockSpace(Vec3d v, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case UP: {
                return new Vec3d(v.field_72450_a, v.field_72449_c, v.field_72448_b);
            }
            case NORTH: {
                return new Vec3d(1.0 - v.field_72450_a, v.field_72448_b, 1.0 - v.field_72449_c);
            }
            case SOUTH: {
                return v;
            }
            case WEST: {
                return new Vec3d(v.field_72449_c, v.field_72448_b, 1.0 - v.field_72450_a);
            }
            case EAST: {
                return new Vec3d(1.0 - v.field_72449_c, v.field_72448_b, v.field_72450_a);
            }
        }
        return v;
    }

    public static Direction getTopDirection(Direction rotation) {
        switch (rotation) {
            case DOWN: {
                return Direction.SOUTH;
            }
            case UP: {
                return Direction.NORTH;
            }
        }
        return Direction.UP;
    }

    public static Direction getBottomDirection(Direction rotation) {
        switch (rotation) {
            case DOWN: {
                return Direction.NORTH;
            }
            case UP: {
                return Direction.SOUTH;
            }
        }
        return Direction.DOWN;
    }

    public static Direction worldToBlockSpace(Direction side, BlockState state) {
        return OrientationTools.worldToBlockSpace(side, OrientationTools.getOrientation(state));
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, Entity entityIn) {
        if (MathHelper.func_76135_e((float)((float)entityIn.field_70165_t - (float)clickedBlock.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.field_70161_v - (float)clickedBlock.func_177952_p())) < 2.0f) {
            double d0 = entityIn.field_70163_u + (double)entityIn.func_70047_e();
            if (d0 - (double)clickedBlock.func_177956_o() > 2.0) {
                return Direction.UP;
            }
            if ((double)clickedBlock.func_177956_o() - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }

    public static Direction reorient(Direction side, BlockState state) {
        return OrientationTools.reorient(side, OrientationTools.getOrientation(state));
    }

    public static Direction reorientHoriz(Direction side, BlockState state) {
        return OrientationTools.reorient(side, OrientationTools.getOrientationHoriz(state));
    }

    public static Direction reorient(Direction side, Direction blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (side) {
                    case DOWN: {
                        return Direction.SOUTH;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.WEST;
                    }
                }
                return side;
            }
            case UP: {
                switch (side) {
                    case DOWN: {
                        return Direction.NORTH;
                    }
                    case UP: {
                        return Direction.SOUTH;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.EAST;
                    }
                }
                return side;
            }
            case NORTH: {
                if (side == Direction.DOWN || side == Direction.UP) {
                    return side;
                }
                return side.func_176734_d();
            }
            case SOUTH: {
                return side;
            }
            case WEST: {
                if (side == Direction.DOWN || side == Direction.UP) {
                    return side;
                }
                if (side == Direction.WEST) {
                    return Direction.SOUTH;
                }
                if (side == Direction.NORTH) {
                    return Direction.WEST;
                }
                if (side == Direction.EAST) {
                    return Direction.NORTH;
                }
                return Direction.EAST;
            }
            case EAST: {
                if (side == Direction.DOWN || side == Direction.UP) {
                    return side;
                }
                if (side == Direction.WEST) {
                    return Direction.NORTH;
                }
                if (side == Direction.NORTH) {
                    return Direction.EAST;
                }
                if (side == Direction.EAST) {
                    return Direction.SOUTH;
                }
                return Direction.WEST;
            }
        }
        return side;
    }
}

