/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Type;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class TabbedPanel
extends AbstractContainerWidget<Panel> {
    public static final String TYPE_TABBEDPANEL = "tabbedpanel";
    private Widget<?> current = null;
    private Map<String, Widget<?>> pages = new HashMap();

    public TabbedPanel(Minecraft mc, Screen gui) {
        super(mc, gui);
    }

    public TabbedPanel addPage(String name, Widget<?> child) {
        this.addChild(child);
        this.pages.put(name, child);
        return this;
    }

    public Widget<?> getCurrent() {
        return this.current;
    }

    public String getCurrentName() {
        for (Map.Entry<String, Widget<?>> me : this.pages.entrySet()) {
            if (this.current != me.getValue()) continue;
            return me.getKey();
        }
        return null;
    }

    public TabbedPanel setCurrent(Widget<?> current) {
        this.current = current;
        return this;
    }

    public TabbedPanel setCurrent(String name) {
        this.current = this.pages.get(name);
        return this;
    }

    @Override
    public Widget<?> getWidgetAtPosition(int x, int y) {
        if (this.current == null) {
            return this;
        }
        this.setChildBounds();
        return this.current.getWidgetAtPosition(x -= this.bounds.x, y -= this.bounds.y);
    }

    @Override
    public void draw(int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        this.drawBox(xx, yy, -65536);
        this.setChildBounds();
        if (this.current != null) {
            this.current.setWindow(this.window);
            this.current.draw(xx, yy);
        }
    }

    private void setChildBounds() {
        if (this.isDirty()) {
            for (Widget<?> child : this.getChildren()) {
                child.setBounds(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
            }
            this.markClean();
        }
    }

    @Override
    public Widget<?> mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        this.setChildBounds();
        if (this.current != null && this.current.in(x -= this.bounds.x, y -= this.bounds.y) && this.current.isVisible()) {
            return this.current.mouseClick(x, y, button);
        }
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        this.setChildBounds();
        x -= this.bounds.x;
        y -= this.bounds.y;
        if (this.current != null) {
            this.current.mouseRelease(x, y, button);
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        this.setChildBounds();
        x -= this.bounds.x;
        y -= this.bounds.y;
        if (this.current != null) {
            this.current.mouseMove(x, y);
        }
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_TABBEDPANEL);
    }

    @Override
    public <T> void setGenericValue(T value) {
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        return null;
    }
}

