/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.stal111.forbidden_arcanus.block.WaterloggedBlock;
import com.stal111.forbidden_arcanus.util.VoxelShapeHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class PillarBlock
extends WaterloggedBlock {
    public static final EnumProperty<PillarType> TYPE = EnumProperty.func_177709_a((String)"type", PillarType.class);
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    private static final VoxelShape[] SHAPE_X = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.func_208617_a((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0), Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] SHAPE_Y = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)};
    private static final VoxelShape[] SHAPE_Z = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)3.0), Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), Block.func_208617_a((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)};

    private VoxelShape generateShape(BlockState state) {
        switch ((PillarType)((Object)state.func_177229_b(TYPE))) {
            case SINGLE: {
                switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                    case EAST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X);
                    }
                    case WEST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X);
                    }
                    case NORTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z);
                    }
                    case SOUTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z);
                    }
                }
                return VoxelShapeHelper.combineAll(SHAPE_Y);
            }
            case TOP: {
                switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                    case EAST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X[0], SHAPE_X[1], SHAPE_X[2]);
                    }
                    case WEST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X[2], SHAPE_X[3], SHAPE_X[4]);
                    }
                    case NORTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z[2], SHAPE_Z[3], SHAPE_Z[4]);
                    }
                    case SOUTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z[0], SHAPE_Z[1], SHAPE_Z[2]);
                    }
                }
                return VoxelShapeHelper.combineAll(SHAPE_Y[2], SHAPE_Y[3], SHAPE_Y[4]);
            }
            case MIDDLE: {
                switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                    case EAST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X[2]);
                    }
                    case WEST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X[2]);
                    }
                    case NORTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z[2]);
                    }
                    case SOUTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z[2]);
                    }
                }
                return VoxelShapeHelper.combineAll(SHAPE_Y[2]);
            }
            case BOTTOM: {
                switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                    case EAST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X[2], SHAPE_X[3], SHAPE_X[4]);
                    }
                    case WEST: {
                        return VoxelShapeHelper.combineAll(SHAPE_X[0], SHAPE_X[1], SHAPE_X[2]);
                    }
                    case NORTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z[0], SHAPE_Z[1], SHAPE_Z[2]);
                    }
                    case SOUTH: {
                        return VoxelShapeHelper.combineAll(SHAPE_Z[2], SHAPE_Z[3], SHAPE_Z[4]);
                    }
                }
                return VoxelShapeHelper.combineAll(SHAPE_Y[0], SHAPE_Y[1], SHAPE_Y[2]);
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public PillarBlock(String name, Block.Properties properties) {
        super(name, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a(TYPE, (Comparable)((Object)PillarType.SINGLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.generateShape(state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.generateShape(state);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a(TYPE, (Comparable)((Object)PillarType.SINGLE))).func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)this.tryConnect(state, world, currentPos)));
    }

    public PillarType tryConnect(BlockState state, IWorld world, BlockPos currentPos) {
        BlockState stateDown = world.func_180495_p(currentPos.func_177972_a((Direction)state.func_177229_b((IProperty)FACING)));
        BlockState stateUp = world.func_180495_p(currentPos.func_177967_a((Direction)state.func_177229_b((IProperty)FACING), -1));
        if (stateUp.func_177230_c() == this && stateDown.func_177230_c() == this) {
            boolean blockDown;
            boolean blockUp = ((Direction)stateUp.func_177229_b((IProperty)FACING)).func_176740_k() == ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
            boolean bl = blockDown = ((Direction)stateDown.func_177229_b((IProperty)FACING)).func_176740_k() == ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
            if (blockUp && blockDown) {
                return PillarType.MIDDLE;
            }
            if (blockUp && !blockDown) {
                return PillarType.BOTTOM;
            }
            if (!blockUp && blockDown) {
                return PillarType.TOP;
            }
            return PillarType.SINGLE;
        }
        if (stateUp.func_177230_c() == this && stateDown.func_177230_c() != this) {
            boolean blockUp;
            boolean bl = blockUp = ((Direction)stateUp.func_177229_b((IProperty)FACING)).func_176740_k() == ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
            if (blockUp) {
                return PillarType.BOTTOM;
            }
            return PillarType.SINGLE;
        }
        if (stateUp.func_177230_c() != this && stateDown.func_177230_c() == this) {
            boolean blockDown;
            boolean bl = blockDown = ((Direction)stateDown.func_177229_b((IProperty)FACING)).func_176740_k() == ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
            if (blockDown) {
                return PillarType.TOP;
            }
            return PillarType.SINGLE;
        }
        return PillarType.SINGLE;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                    case NORTH: {
                        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.WEST);
                    }
                    case EAST: {
                        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.SOUTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.EAST);
                    }
                    case WEST: {
                        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH);
                    }
                    case UP: {
                        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.UP);
                    }
                    case DOWN: {
                        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public static enum PillarType implements IStringSerializable
    {
        SINGLE("single"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        public final String type;

        private PillarType(String name) {
            this.type = name;
        }

        public String func_176610_l() {
            return this.type;
        }
    }
}

