/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stal111.forbidden_arcanus.block.BasicBlock;
import com.stal111.forbidden_arcanus.block.ModBlocks;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ArcaneCrystalDustWireBlock
extends BasicBlock {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));

    public ArcaneCrystalDustWireBlock(String name, Block.Properties properties) {
        super(name, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.SOUTH));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.SOUTH)) : (BlockState)stateIn.func_206870_a((IProperty)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((IBlockReader)worldIn, currentPos, facing));
    }

    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags) {
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((IProperty)FACING_PROPERTY_MAP.get(direction));
                if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(direction)).func_177230_c() == this) continue;
                blockpos$pooledmutableblockpos.func_189536_c(Direction.DOWN);
                BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                if (blockstate.func_177230_c() != Blocks.field_190976_dk) {
                    BlockPos blockpos = blockpos$pooledmutableblockpos.func_177972_a(direction.func_176734_d());
                    BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockpos);
                    ArcaneCrystalDustWireBlock.func_196263_a((BlockState)blockstate, (BlockState)blockstate1, (IWorld)worldIn, (BlockPos)blockpos$pooledmutableblockpos, (int)flags);
                }
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(direction).func_189536_c(Direction.UP);
                BlockState blockstate3 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                if (blockstate3.func_177230_c() == Blocks.field_190976_dk) continue;
                BlockPos blockpos1 = blockpos$pooledmutableblockpos.func_177972_a(direction.func_176734_d());
                BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockpos1);
                ArcaneCrystalDustWireBlock.func_196263_a((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)worldIn, (BlockPos)blockpos$pooledmutableblockpos, (int)flags);
            }
        }
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        BlockPos blockpos1 = pos.func_177984_a();
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.func_215686_e(worldIn, blockpos1)) {
            boolean flag;
            boolean bl = flag = Block.func_220056_d((BlockState)blockstate, (IBlockReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
            if (flag && ArcaneCrystalDustWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
                if (ArcaneCrystalDustWireBlock.func_208062_a((VoxelShape)blockstate.func_196952_d(worldIn, blockpos))) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !ArcaneCrystalDustWireBlock.canConnectTo(blockstate, worldIn, blockpos, face) && (blockstate.func_215686_e(worldIn, blockpos) || !ArcaneCrystalDustWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return Block.func_220056_d((BlockState)blockstate, (IBlockReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState p_220082_1_, World worldIn, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (p_220082_4_.func_177230_c() != p_220082_1_.func_177230_c() && !worldIn.field_72995_K) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
                }
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.func_177972_a(direction2);
                    if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                        this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                        continue;
                    }
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        if (!worldIn.field_72995_K && !state.func_196955_c((IWorldReader)worldIn, pos)) {
            ArcaneCrystalDustWireBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        Block block = blockState.func_177230_c();
        if (block == ModBlocks.arcane_crystal_dust_wire) {
            return true;
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }
}

