/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class BaseTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private final int logShape;
    private final int leafesShape;
    private final int minHeight;
    private final int maxHeight;
    private final int minRadius;
    private final int maxRadius;
    private final BlockState log;
    private final BlockState leaf;
    private final float leave_percentage;

    public BaseTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, BlockState log, int logShape, BlockState leaf, int leafesShape, int minHeight, int maxHeight, int minRadius, int maxRadius, float leave_percentage) {
        super(config, false);
        this.log = log;
        this.logShape = logShape;
        this.leaf = leaf;
        this.leafesShape = leafesShape;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.leave_percentage = leave_percentage;
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random rand, BlockPos pos, MutableBoundingBox mutbounding) {
        int height = this.minHeight + rand.nextInt(this.maxHeight - this.minHeight);
        int radius = this.minRadius + rand.nextInt(this.maxRadius - this.minRadius);
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.getMaxHeight()) {
            if (!this.enoughSpace(world, pos, height, radius)) {
                return false;
            }
            if (BaseTreeFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b(), (IPlantable)this.getSapling()) && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
                this.generateLogs(changedBlocks, world, pos, height, radius, mutbounding);
                this.generateLeafes(changedBlocks, world, pos, height, radius, this.leave_percentage, mutbounding);
                return true;
            }
        }
        return false;
    }

    protected boolean enoughSpace(IWorldGenerationReader world, BlockPos pos, int height, int radius) {
        boolean flag = true;
        for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + height; ++y) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius && flag; ++x) {
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius && flag; ++z) {
                    if (y >= 0 && y < world.getMaxHeight()) {
                        if (BaseTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(x, y, z))) continue;
                        System.out.println(x + ":" + y + ":" + z);
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected void generateLeafes(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, int height, int radius, float leave_percentage, MutableBoundingBox mutbounding) {
        int leafes_start = (int)((float)height * (1.0f - leave_percentage));
        int leafes_height = height - leafes_start;
        int sphereradius = leafes_height / 2;
        BlockPos spherecenter = pos.func_177981_b(leafes_start + sphereradius);
        BlockPos leavesStartPosCenter = pos.func_177981_b(leafes_start);
        for (int y = pos.func_177956_o() + leafes_start; y < pos.func_177956_o() + height; ++y) {
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                block11: for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    BlockPos actualpos = new BlockPos(x, y, z);
                    switch (this.leafesShape) {
                        case 1: {
                            if (!(actualpos.func_218140_a((double)spherecenter.func_177958_n(), (double)spherecenter.func_177956_o(), (double)spherecenter.func_177952_p(), false) <= (double)(sphereradius * sphereradius)) || !BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                            continue block11;
                        }
                        case 2: {
                            if (!(actualpos.func_218140_a((double)spherecenter.func_177958_n(), (double)actualpos.func_177956_o(), (double)spherecenter.func_177952_p(), false) <= (double)(sphereradius * sphereradius)) || !BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                            continue block11;
                        }
                        case 3: {
                            if (!(actualpos.func_218140_a((double)leavesStartPosCenter.func_177958_n(), (double)leavesStartPosCenter.func_177956_o(), (double)leavesStartPosCenter.func_177952_p(), false) <= (double)(sphereradius * 2 * sphereradius)) || !BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                            continue block11;
                        }
                        case 4: {
                            if (Math.abs(x - pos.func_177958_n()) + Math.abs(y - pos.func_177956_o()) + Math.abs(z - pos.func_177952_p()) > leafes_height + 1 || !BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                            continue block11;
                        }
                        case 5: {
                            if (Math.abs(x - spherecenter.func_177958_n()) + Math.abs(y - spherecenter.func_177956_o()) + Math.abs(z - spherecenter.func_177952_p()) > sphereradius + 1 || !BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                            continue block11;
                        }
                        case 6: {
                            if (Math.abs(x - spherecenter.func_177958_n()) + Math.abs(y - spherecenter.func_177956_o()) + Math.abs(z - spherecenter.func_177952_p()) > sphereradius + 1 || Math.abs(x - spherecenter.func_177958_n()) != 0 && Math.abs(z - spherecenter.func_177952_p()) != 0 || !BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                            continue block11;
                        }
                        case 7: {
                            continue block11;
                        }
                        default: {
                            if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue block11;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.leaf, mutbounding);
                        }
                    }
                }
            }
        }
    }

    protected void generateLogs(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, int height, int radius, MutableBoundingBox mutbounding) {
        int logsheight = (int)((float)height * 0.6f);
        BlockPos logsEndPos = pos.func_177981_b(logsheight);
        switch (this.logShape) {
            case 1: {
                float m = (float)logsheight / ((float)radius - 1.0f);
                int distance = 0;
                for (int y = 0; y <= logsheight; ++y) {
                    for (int x = 0; x < radius; ++x) {
                        if (Math.floor((float)x * m) != (double)y) continue;
                        distance = x;
                    }
                    if (distance > 0) {
                        if (BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y).func_177964_d(distance))) {
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(y).func_177964_d(distance), this.log, mutbounding);
                        }
                        if (BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y).func_177965_g(distance))) {
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(y).func_177965_g(distance), this.log, mutbounding);
                        }
                        if (BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y).func_177970_e(distance))) {
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(y).func_177970_e(distance), this.log, mutbounding);
                        }
                        if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y).func_177985_f(distance))) continue;
                        this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(y).func_177985_f(distance), this.log, mutbounding);
                        continue;
                    }
                    if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(y), this.log, mutbounding);
                }
                break;
            }
            case 2: {
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + logsheight; ++y) {
                    for (int x = pos.func_177958_n() - radius + 1; x <= pos.func_177958_n() + radius - 1; ++x) {
                        for (int z = pos.func_177952_p() - radius + 1; z <= pos.func_177952_p() + radius - 1; ++z) {
                            if (Math.abs(x - pos.func_177958_n()) != 2 && Math.abs(z - pos.func_177952_p()) != 2) continue;
                            BlockPos actualpos = new BlockPos(x, y, z);
                            if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + logsheight; ++y) {
                    for (int x = pos.func_177958_n() - radius + 1; x <= pos.func_177958_n() + radius - 1; ++x) {
                        for (int z = pos.func_177952_p() - radius + 1; z <= pos.func_177952_p() + radius - 1; ++z) {
                            if (Math.abs(x - pos.func_177958_n()) > 2 || Math.abs(z - pos.func_177952_p()) > 2) continue;
                            BlockPos actualpos = new BlockPos(x, y, z);
                            if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + logsheight; ++y) {
                    for (int x = pos.func_177958_n() - radius + 1; x <= pos.func_177958_n() + radius - 1; ++x) {
                        for (int z = pos.func_177952_p() - radius + 1; z <= pos.func_177952_p() + radius - 1; ++z) {
                            if (Math.abs(x - pos.func_177958_n()) > 1 || Math.abs(z - pos.func_177952_p()) > 1) continue;
                            BlockPos actualpos = new BlockPos(x, y, z);
                            if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                        }
                    }
                }
                break;
            }
            case 5: {
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + logsheight; ++y) {
                    for (int x = pos.func_177958_n() - radius + 1; x <= pos.func_177958_n() + radius - 1; ++x) {
                        for (int z = pos.func_177952_p() - radius + 1; z <= pos.func_177952_p() + radius - 1; ++z) {
                            if (Math.abs(x - pos.func_177958_n()) != 0 && Math.abs(z - pos.func_177952_p()) != 0) continue;
                            BlockPos actualpos = new BlockPos(x, y, z);
                            if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + logsheight; ++y) {
                    for (int x = pos.func_177958_n() - radius + 1; x <= pos.func_177958_n() + radius - 1; ++x) {
                        for (int z = pos.func_177952_p() - radius + 1; z <= pos.func_177952_p() + radius - 1; ++z) {
                            if (Math.abs(x - pos.func_177958_n()) != 0 && Math.abs(z - pos.func_177952_p()) != 0 || Math.abs(x - pos.func_177958_n()) + Math.abs(y - pos.func_177956_o()) + Math.abs(z - pos.func_177952_p()) > logsheight / 2 && Math.abs(x - logsEndPos.func_177958_n()) + Math.abs(y - logsEndPos.func_177956_o()) + Math.abs(z - logsEndPos.func_177952_p()) > logsheight / 2) continue;
                            BlockPos actualpos = new BlockPos(x, y, z);
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                        }
                    }
                }
                break;
            }
            case 7: {
                int radius2 = radius / 2;
                for (int y = 0; y <= logsheight; ++y) {
                    int x = (int)((double)radius2 * Math.cos(y));
                    int z = (int)((double)radius2 * Math.sin(y));
                    BlockPos actualpos = new BlockPos(x + pos.func_177958_n(), y + pos.func_177956_o(), z + pos.func_177952_p());
                    if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                }
                break;
            }
            case 8: {
                int radius3 = radius / 2;
                for (int y = 0; y <= logsheight; ++y) {
                    BlockPos actualpos2;
                    int x = (int)((double)radius3 * Math.cos(y));
                    int z = (int)((double)radius3 * Math.sin(y));
                    BlockPos actualpos = new BlockPos(x + pos.func_177958_n(), y + pos.func_177956_o(), z + pos.func_177952_p());
                    if (BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)actualpos)) {
                        this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos, this.log, mutbounding);
                    }
                    if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)(actualpos2 = new BlockPos(-x + pos.func_177958_n(), y + pos.func_177956_o(), -z + pos.func_177952_p())))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, actualpos2, this.log, mutbounding);
                }
                break;
            }
            default: {
                for (int y = 0; y < logsheight; ++y) {
                    if (!BaseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(y))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(y), this.log, mutbounding);
                }
            }
        }
    }
}

