/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkUtils {
    public static void sendToTracking(SimpleChannel channel, Object packet, ServerWorld world, BlockPos pos) {
        world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).forEach(p -> channel.sendTo(packet, p.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <MSG> void registerMessage(SimpleChannel channel, int id, Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        channel.registerMessage(id, messageType, encoder, decoder, messageConsumer);
    }

    public static <T> void registerMessage(SimpleChannel channel, int id, MessageProvider<T> prov) {
        channel.registerMessage(id, prov.getMsgClass(), prov::write, prov::read, prov::handle);
    }

    public static void handlePacket(Supplier<Runnable> r, NetworkEvent.Context ctx) {
        ctx.enqueueWork(r.get());
        ctx.setPacketHandled(true);
    }

    public static abstract class MessageProvider<T> {
        public Class<T> getMsgClass() {
            return this.getClass();
        }

        public abstract void write(T var1, PacketBuffer var2);

        public abstract T read(PacketBuffer var1);

        public abstract void handle(T var1, Supplier<NetworkEvent.Context> var2);
    }
}

