/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.recipe;

import com.google.gson.JsonObject;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class TagIngredient
extends Ingredient {
    public static final IIngredientSerializer<TagIngredient> SERIALIZER = new IIngredientSerializer<TagIngredient>(){

        public TagIngredient parse(PacketBuffer buffer) {
            ResourceLocation tag = new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE));
            return new TagIngredient(tag);
        }

        public TagIngredient parse(JsonObject json) {
            throw new UnsupportedOperationException();
        }

        public void write(PacketBuffer buffer, TagIngredient ingredient) {
            buffer.func_180714_a(ingredient.tag.func_199886_b().toString());
        }
    };
    protected ResourceLocation tagId;
    protected Tag<Item> tag;
    protected ItemStack[] stacks;

    public TagIngredient(Tag<Item> tag) {
        super(Stream.of(new Ingredient.TagList(tag)));
        this.tag = tag;
        this.stacks = new ItemStack[0];
    }

    public TagIngredient(ResourceLocation tag) {
        this((Tag<Item>)new ItemTags.Wrapper(tag));
    }

    public boolean test(ItemStack stack) {
        return this.tag.func_199685_a_((Object)stack.func_77973_b());
    }

    public ItemStack[] func_193365_a() {
        if (this.tag.func_199885_a().size() != this.stacks.length) {
            this.stacks = this.tag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList()).toArray(new ItemStack[0]);
        }
        return this.stacks;
    }

    public boolean func_203189_d() {
        return this.tag.func_199885_a().isEmpty();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }
}

