/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.world;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.mechanisms.world.feature.OilLakesFeature;

public final class SMWorldFeatures {
    private SMWorldFeatures() {
    }

    public static void addFeaturesToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
            for (Ores ore : Ores.values()) {
                SMWorldFeatures.addOre(biome, ore);
            }
            biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)OilLakesFeature.INSTANCE, (IFeatureConfig)new LakesConfig(ModBlocks.oil.func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(6)));
        }
    }

    private static void addOre(Biome biome, Ores ore) {
        ore.getConfig().ifPresent(config -> biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ore.getBlock().func_176223_P(), config.getVeinSize()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(config.getVeinCount(), config.getMinHeight(), 0, config.getMaxHeight()))));
    }
}

