/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.util;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TextUtil {
    private static final String ENERGY_FORMAT = "%,d";

    public static ITextComponent translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "silents_mechanisms", suffix);
        return new TranslationTextComponent(key, params);
    }

    public static ITextComponent energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return TextUtil.translate("misc", "energy", s1);
    }

    public static ITextComponent energyPerTick(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return TextUtil.translate("misc", "energyPerTick", s1);
    }

    public static ITextComponent energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return TextUtil.translate("misc", "energyWithMax", s1, s2);
    }

    public static ITextComponent fluidWithMax(IFluidHandler fluidHandler, int tank) {
        FluidStack fluid = fluidHandler.getFluidInTank(tank);
        ITextComponent fluidName = fluid.getDisplayName();
        String s1 = String.format(ENERGY_FORMAT, fluid.getAmount());
        String s2 = String.format(ENERGY_FORMAT, fluidHandler.getTankCapacity(tank));
        return TextUtil.translate("misc", "fluidWithMax", fluidName, s1, s2);
    }
}

