/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterScreen;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxContainer;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxScreen;
import net.silentchaos512.mechanisms.block.compressor.CompressorContainer;
import net.silentchaos512.mechanisms.block.compressor.CompressorScreen;
import net.silentchaos512.mechanisms.block.crusher.CrusherScreen;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceContainer;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceScreen;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorContainer;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorScreen;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorContainer;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorScreen;
import net.silentchaos512.mechanisms.block.refinery.RefineryContainer;
import net.silentchaos512.mechanisms.block.refinery.RefineryScreen;
import net.silentchaos512.mechanisms.init.MachineType;
import net.silentchaos512.mechanisms.util.MachineTier;

public final class ModContainers {
    public static ContainerType<BatteryBoxContainer> batteryBox;
    public static ContainerType<CoalGeneratorContainer> coalGenerator;
    public static ContainerType<CompressorContainer> compressor;
    public static ContainerType<ElectricFurnaceContainer> electricFurnace;
    public static ContainerType<LavaGeneratorContainer> lavaGenerator;
    public static ContainerType<RefineryContainer> refinery;

    private ModContainers() {
    }

    public static void registerAll(RegistryEvent.Register<ContainerType<?>> event) {
        ModContainers.register("basic_alloy_smelter", MachineType.ALLOY_SMELTER.getContainerType(MachineTier.BASIC));
        ModContainers.register("alloy_smelter", MachineType.ALLOY_SMELTER.getContainerType(MachineTier.STANDARD));
        batteryBox = ModContainers.register("battery_box", BatteryBoxContainer::new);
        coalGenerator = ModContainers.register("coal_generator", CoalGeneratorContainer::new);
        compressor = ModContainers.register("compressor", CompressorContainer::new);
        ModContainers.register("basic_crusher", MachineType.CRUSHER.getContainerType(MachineTier.BASIC));
        ModContainers.register("crusher", MachineType.CRUSHER.getContainerType(MachineTier.STANDARD));
        electricFurnace = ModContainers.register("electric_furnace", ElectricFurnaceContainer::new);
        lavaGenerator = ModContainers.register("lava_generator", LavaGeneratorContainer::new);
        refinery = ModContainers.register("refinery", RefineryContainer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreens(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(MachineType.ALLOY_SMELTER.getContainerType(MachineTier.BASIC), AlloySmelterScreen::new);
        ScreenManager.func_216911_a(MachineType.ALLOY_SMELTER.getContainerType(MachineTier.STANDARD), AlloySmelterScreen::new);
        ScreenManager.func_216911_a(batteryBox, BatteryBoxScreen::new);
        ScreenManager.func_216911_a(coalGenerator, CoalGeneratorScreen::new);
        ScreenManager.func_216911_a(compressor, CompressorScreen::new);
        ScreenManager.func_216911_a(MachineType.CRUSHER.getContainerType(MachineTier.BASIC), CrusherScreen::new);
        ScreenManager.func_216911_a(MachineType.CRUSHER.getContainerType(MachineTier.STANDARD), CrusherScreen::new);
        ScreenManager.func_216911_a(electricFurnace, ElectricFurnaceScreen::new);
        ScreenManager.func_216911_a(lavaGenerator, LavaGeneratorScreen::new);
        ScreenManager.func_216911_a(refinery, RefineryScreen::new);
    }

    private static <C extends Container> ContainerType<C> register(String name, ContainerType.IFactory<C> containerFactory) {
        ContainerType type = new ContainerType(containerFactory);
        return ModContainers.register(name, type);
    }

    private static <C extends Container> ContainerType<C> register(String name, ContainerType<C> containerType) {
        containerType.setRegistryName(SilentMechanisms.getId(name));
        ForgeRegistries.CONTAINERS.register(containerType);
        return containerType;
    }
}

